from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class ExportLogs:
    """*
    Export scanner logs.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportLogs",
    "Input":true
    }
    }
    ```

    > Export file buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":41337,
    "Task":{
    "Index":1,
    "Type":"ExportLogs",
    "Input":true
    }
    }
    }
    ```

    > Export file binary data transfer from server [41337 bytes].

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ExportLogs"
    "Input":true,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ExportLogs` task.
        """
        def __init__(self, Index: int, Type: str, Input: bool = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ExportLogs"
            self.Type = Type
            # Export log images.  If unspecified, log images are not exported.
            self.Input = Input

    class Response:

        """
         Server response for the `ExportLogs` task.
        """
        def __init__(self, Index: int, Type: str, Input: bool = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ExportLogs"
            self.Type = Type
            # Requested export log images.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Server buffer message for the `ExportLogs` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested ExportLogs task.
            self.Task = Task

    def __init__(self):
        pass

