from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class FactoryReset:
    """*
    Reset the scanner to factory settings.
    This removes all projects and restores factory calibration.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"FactoryReset"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"FactoryReset"
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `FactoryReset` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "FactoryReset"
            self.Type = Type

    class Response:

        """
         Server response for the `FactoryReset` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "FactoryReset"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

