from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class FlattenGroup:
    """*
    Flatten a scan group such that it only consists of single scans.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"FlattenGroup",
    "Input":0
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"FlattenGroup",
    "Input":0,
    "Output":{
    "groups":[{
    "index":2,
    "name":"Group 2",
    "groups":[{
    "index":1,
    "name":"Group 1"
    }]
    }],
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `FlattenGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "FlattenGroup"
            self.Type = Type
            # The index of the group to flatten.
            self.Input = Input

    class Response:

        """
         Server response for the `FlattenGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "FlattenGroup"
            self.Type = Type
            # The requested index of the group to flatten.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

