from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class HasCameras:
    """*
    Check if the scanner has working cameras.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasCameras"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasCameras",
    "Output":true,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `HasCameras` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "HasCameras"
            self.Type = Type

    class Response:

        """
         Server response for the `HasCameras` task.
        """
        def __init__(self, Index: int, Type: str, Output: bool = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "HasCameras"
            self.Type = Type
            # The working state of the cameras.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

