from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class HasProjector:
    """*
    Check if the scanner has a working projector.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasProjector"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasProjector",
    "Output":true,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `HasProjector` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "HasProjector"
            self.Type = Type

    class Response:

        """
         Server response for the `HasProjector` task.
        """
        def __init__(self, Index: int, Type: str, Output: bool = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "HasProjector"
            self.Type = Type
            # The working state of the projector.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

