from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class HasTurntable:
    """*
    Check if the scanner is connected to a working turntable.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasTurntable"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HasTurntable",
    "Output":true,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `HasTurntable` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "HasTurntable"
            self.Type = Type

    class Response:

        """
         Server response for the `HasTurntable` task.
        """
        def __init__(self, Index: int, Type: str, Output: bool = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "HasTurntable"
            self.Type = Type
            # The working start of the connected turntable.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

