from MF.V3.Descriptors.HeatMap import HeatMap as MF_V3_Descriptors_HeatMap_HeatMap
from MF.V3.Settings.HeatMap import HeatMap as MF_V3_Settings_HeatMap_HeatMap
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class HeatMap:
    """*
    Compute the point-to-mesh distances of a source mesh to a target mesh and visualize as a heat map.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HeatMap",
    "Input":{"sources":[2],"targets":[3]}
    }
    }
    ```

    > Vertex position buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":1558188,
    "Descriptor":{
    "components":[{
    "type":"Position"
    "size":3,
    "offset":0,
    "normalized":false,
    }],
    "stride":3
    },
    "Task":{
    "Index":1,
    "Type":"HeatMap",
    "Input":{"sources":[2],"targets":[3]}
    }
    }
    }
    ```

    > Vertex position binary data transfer from server [1558188 bytes].

    > Vertex quality buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":1558188,
    "Descriptor":{
    "components":[{
    "type":"Quality"
    "size":3,
    "offset":0,
    "normalized":false,
    }],
    "stride":3
    },
    "Task":{
    "Index":1,
    "Type":"HeatMap",
    "Input":{"sources":[2],"targets":[3]}
    }
    }
    }
    ```

    > Vertex quality binary data transfer from server [1558188 bytes].

    > Triangle index buffer message from server.

    ```json
    {
    "Buffer":{
    "Index":4,
    "Size":1996356,
    "Descriptor":{
    "components":[{
    "type":"Triangle"
    "size":1,
    "offset":0,
    "normalized":false,
    }],
    "stride":1
    },
    "Task":{
    "Index":1,
    "Type":"HeatMap",
    "Input":{"sources":[2],"targets":[3]}
    }
    }
    }
    ```

    > Triangle index binary data transfer from server [1996356 bytes].

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"HeatMap",
    "Input":{"sources":[2],"targets":[3]},
    "Output":{
    "count":96564,
    "max":32.734107971191406,
    "mean":1.964127540588379,
    "median":0.12784385681152344,
    "min":9.611248970031738e-07,
    "outlierDistance":0.0,
    "stddev":4.970643997192383
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `HeatMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_HeatMap_HeatMap):
            # A unique identifier generated by the client.
            self.Index = Index
            # "HeatMap"
            self.Type = Type
            # The heat map settings.
            self.Input = Input

    class Response:

        """
         Server response for the `HeatMap` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_HeatMap_HeatMap, Output: MF_V3_Descriptors_HeatMap_HeatMap, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "HeatMap"
            self.Type = Type
            # The requested heat map settings.
            self.Input = Input
            # The heat map descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

