from MF.V3.Settings.Import import Import as MF_V3_Settings_Import_Import
from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class Import:
    """*
    Import a set of 3D meshes to the current open project.  The meshes must be archived in a ZIP file.  Supported formats are DAE, FBX, GLB, OBJ, PLY and STL.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Import",
    "Input":{"unit":"Inch"}
    }
    }
    ```

    > Buffer message from client.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":1052,
    "Task":{
    "Index":1,
    "Type":"Import",
    "Input":{"unit":"Inch"}
    }
    }
    }
    ```

    > Binary data transfer from client: The mesh zip file [1052 bytes].
    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Import",
    "Input":{"unit":"Inch"},
    "Output":{
    "groups":[{"index":1,"name":"box","scan":1}],
    "imported":[{"file":"mesh.ply"}],
    "ignored":[],
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `Import` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Import_Import = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "Import"
            self.Type = Type
            # Import settings.
            self.Input = Input

    class Response:

        """
         Server response for the `Import` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Import_Import = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "Import"
            self.Type = Type
            # Requested export settings.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Client buffer message for the `Import` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested Import task.
            self.Task = Task

    def __init__(self):
        pass

