from MF.V3.Descriptors.Export import Export as MF_V3_Descriptors_Export_Export
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class ListExportFormats:
    """*
    List all export formats and the geometry elements they support.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListExportFormats"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListExportFormats",
    "Output":{[
    {
    "format": "ply",
    "colors": true,
    "description": "Polygon format",
    "extension": ".ply",
    "faces": ["Point","Triangle","Quad"],
    "normals": true,
    "textures": "Single"
    },
    {
    "format": "obj",
    "colors": true,
    "description": "Wavefront format",
    "extension": ".obj",
    "faces": ["Point","Triangle","Quad"],
    "normals": true,
    "textures": "Multiple"
    },
    {
    "format": "stl",
    "colors": false,
    "description": "Stereolithography format",
    "extension": ".stl",
    "faces": ["Point","Triangle"],
    "normals": true,
    "textures": "None"
    }
    ]},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListExportFormats` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListExportFormats"
            self.Type = Type

    class Response:

        """
         Server response for the `ListExportFormats` task.
        """
        def __init__(self, Index: int, Type: str, Output: List[MF_V3_Descriptors_Export_Export] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListExportFormats"
            self.Type = Type
            # The list of export format descriptors.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

