from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class ListGroups:
    """*
    List the scan groups in the current open project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListGroups"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListGroups",
    "Output":{
    "groups":[
    {
    "index":1,
    "scan":1,
    "name":"Scan-1",
    "color":[0.75,0.5,0.2,1.0],
    "rotation":[0.03,0.1,-0.01],
    "translation":[-101,67,-561],
    "visible":true
    },
    {
    "index":2,
    "scan":2,
    "name":"Scan-2",
    "color":[0.7,0.9,0.6,1.0],
    "rotation":[0.1,0.2,0.5],
    "translation":[-90,64,-553],
    "visible":true
    },
    {
    "index":3,
    "scan":3,
    "name":"Scan-3",
    "color":[0.6,0.8,0.9,1.0],
    "visible":true
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListGroups` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListGroups"
            self.Type = Type

    class Response:

        """
         Server response for the `ListGroups` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListGroups"
            self.Type = Type
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

