from MF.V3.Descriptors.Network import Interface as MF_V3_Descriptors_Network_Interface
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class ListNetworkInterfaces:
    """*
    List network interfaces.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListNetworkInterfaces"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListNetworkInterfaces",
    "Output":[
    {"ip":"192.168.1.234","name":"eth0","ssid":""},
    {"ip":"127.0.0.1","name":"lo","ssid":""}
    {"ip":"192.168.2.345","name":"wlan0","ssid":"Network1"}
    ],
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListNetworkInterfaces` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListNetworkInterfaces"
            self.Type = Type

    class Response:

        """
         Server response for the `ListNetworkInterfaces` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Network_Interface = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListNetworkInterfaces"
            self.Type = Type
            # Network interface descriptors.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

