from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class ListProjects:
    """*
    List all projects.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListProjects"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListProjects",
    "Output":[
    {"index":1,"modified":[2024,5,12,11,23,17],"name":"Project 1","size":35409834},
    {"index":2,"modified":[2024,5,12,11,2,37],"name":"Project 2","size":175025367},
    {"index":3,"modified":[2024,5,6,17,15,53],"name":"Project 3","size":24314083}
    ],
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListProjects` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListProjects"
            self.Type = Type

    class Response:

        """
         Server response for the `ListProjects` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Brief = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListProjects"
            self.Type = Type
            # Brief project descriptors.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

