from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class ListScans:
    """*
    List the scans in the current open project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListScans"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListScans",
    "Output":{[
    {
    "color":[0.8,0.5,0.6,1.0],
    "index":1,
    "name":"Scan-1",
    "scan":1,
    "rotation":[0.2,0.8,-0.1],
    "translation":[-275,-32,-134],
    "visible":true
    },
    {
    "color":[0.5,0.7,0.2,1.0],
    "index":2,
    "name":"Scan-2",
    "scan":2,
    "rotation":[0.7,-0.5,0.3],
    "translation":[75,-62,38],
    "visible":true
    },
    ]},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListScans` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListScans"
            self.Type = Type

    class Response:

        """
         Server response for the `ListScans` task.
        """
        def __init__(self, Index: int, Type: str, Output: List[MF_V3_Descriptors_Project_Project.Group] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListScans"
            self.Type = Type
            # The list of scans in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

