from MF.V3.Descriptors.Wifi import Wifi as MF_V3_Descriptors_Wifi_Wifi
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class ListWifi:
    """*
    List available wifi networks.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListWifi"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"ListWifi",
    "Output":{
    "networks":[
    {"ssid":"Network1","isActive":true,"isPublic":false,"quality":90},
    {"ssid":"Network2","isActive":true,"isPublic":true,"quality":50},
    {"ssid":"Network3","isActive":true,"isPublic":true,"quality":75}
    ],
    "ssid":"Network1"
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `ListWifi` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "ListWifi"
            self.Type = Type

    class Response:

        """
         Server response for the `ListWifi` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Wifi_Wifi = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "ListWifi"
            self.Type = Type
            # The wifi descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

