from MF.V3.Descriptors.Merge import Merge as MF_V3_Descriptors_Merge_Merge
from MF.V3.Settings.Merge import Merge as MF_V3_Settings_Merge_Merge
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class Merge:
    """*
    Merge two or more scan groups.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Merge",
    "Input":{
    "selection":{"mode":"visible"},
    "remesh":{
    "method": "FlowTriangles",
    "quality": "Medium"
    },
    "simplify":{"triangleCount": 20000 }
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Merge",
    "Input":{
    "selection":{"mode":"visible"},
    "remesh":{
    "method": "FlowTriangles",
    "quality": "Medium"
    },
    "simplify":{"triangleCount": 20000 }
    },
    "Output":{
    "meshes":[
    {
    "name":"Combined",
    "positions":237757,
    "normals":237757,
    "triangles":459622,
    "size":11221632
    },
    {
    "name":"Remeshed",
    "positions":34311,
    "normals":0,
    "triangles":29738,
    "size":945540
    },
    {
    "name":"Simplified",
    "positions":32415,
    "normals":0,
    "triangles":20000,
    "size":628980
    }
    ],
    "scans":3,
    "textures":3
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `Merge` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Merge_Merge):
            # A unique identifier generated by the client.
            self.Index = Index
            # "Merge"
            self.Type = Type
            # The merge settings.
            self.Input = Input

    class Response:

        """
         Server response for the `Merge` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Merge_Merge, Output: MF_V3_Descriptors_Merge_Merge, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "Merge"
            self.Type = Type
            # The requested merge settings.
            self.Input = Input
            # The merge descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

