from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class MoveGroup:
    """*
    Move a scan group.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"MoveGroup",
    "Input":[1,2,0]
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"MoveGroup",
    "Input":[1,2,0],
    "Output":{
    "groups":[{
    "index":2,
    "name":"Group 2",
    "groups":[{
    "index":1,
    "name":"Group 1"
    }]
    }],
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `MoveGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: List[int] = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "MoveGroup"
            self.Type = Type
            """
            The requested source and destination move indices.
            An Array of group indexes where
            1. The first is the index of the _source group_: the group to be moved.
            2. The second is the index of the _parent group_: the group into which the source group is moved.
            3. (Optional) The third is the zero-based order in which the source group is placed the other children of the parent group. Use `0` to insert the source group at the beginning of the parent group's children. If omitted, the source group is inserted at the end of the parent group's children.
            """
            self.Input = Input

    class Response:

        """
         Server response for the `MoveGroup` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Group, Input: List[int] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "MoveGroup"
            self.Type = Type
            # The root scan group in the current open project.
            self.Output = Output
            # The requested source and destination move indices.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

