from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.NewGroup import NewGroup as MF_V3_Settings_NewGroup_NewGroup
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class NewGroup:
    """*
    Create a new scan group.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewGroup",
    "Input":{
    "parentIndex":0,
    "baseName":"Group"
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewGroup",
    "Input":{
    "parentIndex":0,
    "baseName":"Group"
    },
    "Output":{
    "groups":[
    {
    "index":1,
    "name":"Group 1"
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `NewGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_NewGroup_NewGroup = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "NewGroup"
            self.Type = Type
            # The requested new group settings.
            self.Input = Input

    class Response:

        """
         Server response for the `NewGroup` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Group, Input: MF_V3_Settings_NewGroup_NewGroup = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "NewGroup"
            self.Type = Type
            # The root scan group in the current open project.
            self.Output = Output
            # The requested new group settings.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

