from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.Project import Project as MF_V3_Settings_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class NewProject:
    """*
    Create a new project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewProject",
    "Input":"New Project Name"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewProject",
    "Input":{
    "name":"New Project Name"
    },
    "Output":{
    "index":5,
    "name":"New Project Name"
    }
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `NewProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: str = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "NewProject"
            self.Type = Type
            # Optional new project name.
            self.Input = Input

    class Response:

        """
         Server response for the `NewProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Project_Project = None, Output: MF_V3_Descriptors_Project_Project = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "NewProject"
            self.Type = Type
            # Requested new project name.
            self.Input = Input
            # The new project descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

