from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.Scan import Scan as MF_V3_Settings_Scan_Scan
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class NewScan:
    """*
    Capture a new scan.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewScan"
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    },
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"NewScan"
    "Input":{
    "camera":{"exposure":18000,"analogGain":256,"digitalGain":256},
    "capture":{"quality":"Medium","texture":true},
    "projector":{"brightness":0.8}
    },
    "Output":{
    "groups":[{
    "color":[0.8,0.5,0.6,1.0],
    "index":1,
    "name":"Scan-1",
    "scan":1,
    "rotation":[0.2,0.8,-0.1],
    "translation":[-275,-32,-134],
    "visible":true
    }],
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `NewScan` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Scan_Scan = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "NewScan"
            self.Type = Type
            # Scan settings.
            self.Input = Input

    class Response:

        """
         Server response for the `NewScan` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Scan_Scan = None, Output: MF_V3_Descriptors_Project_Project.Group = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "NewScan"
            self.Type = Type
            # Requested scan settings.
            self.Input = Input
            # Project group descriptor with the updated list of scans.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

