from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class OpenProject:
    """*
    Create a new project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"OpenProject",
    "Input":5
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"OpenProject",
    "Input":5,
    "Output":{
    "index":5,
    "name":"Project 5"
    }
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `OpenProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "OpenProject"
            self.Type = Type
            # The index of the project to open.  Project indices can be obtained from the `ListProjects` task.
            self.Input = Input

    class Response:

        """
         Server response for the `OpenProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, Output: MF_V3_Descriptors_Project_Project = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "OpenProject"
            self.Type = Type
            # The index of the project requested to open.
            self.Input = Input
            # The open project descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

