from MF.V3.Descriptors.Settings.Scanner import Scanner as MF_V3_Descriptors_Settings_Scanner_Scanner
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class PopSettings:
    """*
    Pop and restore scanner settings from the stack and optionally apply the popped settings.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"PopSettings",
    "Input":true
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"PopSettings",
    "Input":true,
    "Output":{
    "camera":{
    "analogGain":{"default":512.0,"max":1024.0,"min":256.0,"value":256.0},
    "autoExposure":{"default":false,"value":false},
    "digitalGain":{"default":256,"max":65536,"min":256,"value":320},
    "exposure":{"default":27000,"max":90000,"min":9000,"value":18000},
    },
    "projector":{
    "brightness":{"default":0.5,"max":1.0,"min":0.0,"value":0.800000011920929},
    "on":{"default":false,"value":true}
    },
    "turntable":{
    "scans":{"default":8,"max":24,"min":1,"value":3},
    "sweep":{"default":360,"max":360,"min":5,"value":90},
    "use":{"default":true,"value":true}
    },
    "capture":{
    "quality":{"default":"Medium","value":"Medium"},
    "texture":{"default":true,"value":true}
    },
    "i18n":{
    "language":{"default":"en","value":"en"}
    },
    "style":{
    "theme":{"default":"Dark","value":"Dark"}
    },
    "viewer":{
    "textureOpacity":{"default":0.5,"max":1.0,"min":0.0,"value":1.0}
    }
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `PopSettings` task.
        """
        def __init__(self, Index: int, Type: str, Input: bool = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "PopSettings"
            self.Type = Type
            # Apply the popped settings. If unspecified popped settings are not applied.
            self.Input = Input

    class Response:

        """
         Server response for the `PopSettings` task.
        """
        def __init__(self, Index: int, Type: str, Input: bool = None, Output: MF_V3_Descriptors_Settings_Scanner_Scanner = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "PopSettings"
            self.Type = Type
            # Request to apply the popped settings.
            self.Input = Input
            # The scanner settings descriptor.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

