from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class RemoveGroups:
    """*
    Remove selected scan groups.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RemoveGroups",
    "Input":[1,2]
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RemoveGroups",
    "Input":[1,2],
    "Output":{"groups":[]},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `RemoveGroups` task.
        """
        def __init__(self, Index: int, Type: str, Input: List[int] = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "RemoveGroups"
            self.Type = Type
            # The list of indices of the scan groups to remove.
            self.Input = Input

    class Response:

        """
         Server response for the `RemoveGroups` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_Project_Project.Group, Input: List[int] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "RemoveGroups"
            self.Type = Type
            # The root scan group in the current open project.
            self.Output = Output
            # The requested of indices of the scan groups to remove.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

