from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class RemoveProjects:
    """*
    Remove selected projects.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RemoveProjects",
    "Input":[1,3,6]
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RemoveProjects",
    "Input":[1,3,6],
    "Output":[
    {"index":2,"modified":[2024,5,12,11,23,17],"name":"Project 2","size":35409834},
    {"index":4,"modified":[2024,5,12,11,2,37],"name":"Project 4","size":175025367},
    {"index":5,"modified":[2024,5,6,17,15,53],"name":"Project 5","size":24314083}
    ],
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `RemoveProjects` task.
        """
        def __init__(self, Index: int, Type: str, Input: List[int] = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "RemoveProjects"
            self.Type = Type
            # The list of indices of the projects to remove.
            self.Input = Input

    class Response:

        """
         Server response for the `RemoveProjects` task.
        """
        def __init__(self, Index: int, Type: str, Input: List[int] = None, Output: MF_V3_Descriptors_Project_Project.Brief = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "RemoveProjects"
            self.Type = Type
            # The list of indices of the requested projects to remove.
            self.Input = Input
            # Brief descriptors of the remaining projects.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

