from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class RestoreFactoryCalibration:
    """*
    Restore factory calibration.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RestoreFactoryCalibration"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RestoreFactoryCalibration",
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `RestoreFactoryCalibration` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "RestoreFactoryCalibration"
            self.Type = Type

    class Response:

        """
         Server response for the `RestoreFactoryCalibration` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "RestoreFactoryCalibration"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

