from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class RotateTurntable:
    """*
    Rotate the turntable.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RotateTurntable",
    "Input":15
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"RotateTurntable",
    "Input":15,
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `RotateTurntable` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "RotateTurntable"
            self.Type = Type
            # The rotation angle in degrees.
            self.Input = Input

    class Response:

        """
         Server response for the `RotateTurntable` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "RotateTurntable"
            self.Type = Type
            # The requested rotation angle in degrees.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

