from MF.V3.Descriptors.Settings.Camera import Camera as MF_V3_Descriptors_Settings_Camera_Camera
from MF.V3.Settings.Camera import Camera as MF_V3_Settings_Camera_Camera
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SetCameras:
    """*
    Apply camera settings to one or both cameras.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetCameras",
    "Input":{
    "analogGain":256,
    "digitalGain":128,
    "exposure":18000
    },
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetCameras"
    "Input":{
    "analogGain":256,
    "digitalGain":512,
    "exposure":18000
    },
    "Output":{
    "analogGain":{"default":512.0,"max":1024.0,"min":256.0,"value":256.0},
    "digitalGain":{"default":256,"max":65536,"min":256,"value":512},
    "exposure":{"default":27000,"max":90000,"min":9000,"value":18000},
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SetCameras` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Camera_Camera = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SetCameras"
            self.Type = Type
            # Camera settings.
            self.Input = Input

    class Response:

        """
         Server response for the `SetCameras` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Camera_Camera = None, Output: MF_V3_Descriptors_Settings_Camera_Camera = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SetCameras"
            self.Type = Type
            # Requested camera settings.
            self.Input = Input
            # Actual camera settings after applying the requested settings.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

