from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.Group import Group as MF_V3_Settings_Group_Group
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SetGroup:
    """*
    Set scan group properties.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetGroup",
    "Input":{
    "index":2,
    "name":"Amazing Scan"
    "color":[1,0,0,1],
    "rotation":[0,3.14,0],
    "translation":[0,10,25]
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetGroup",
    "Input":{
    "index":2,
    "name":"Amazing Scan"
    "color":[1,0,0,1],
    "rotation":[0,3.14,0],
    "translation":[0,10,25]
    }
    "Output":{
    "groups":[
    {
    "index":1,
    "scan":1,
    "name":"Scan-1",
    "color":[0.75,0.5,0.2,1.0],
    "rotation":[0.03,0.1,-0.01],
    "translation":[-101,67,-561],
    "visible":true
    },
    {
    "index":2,
    "scan":2,
    "name":"Amazing Scan",
    "color":[1,0,0,1],
    "rotation":[0,3.14,0],
    "translation":[0,10,25],
    "visible":true
    },
    {
    "index":3,
    "scan":3,
    "name":"Scan-3",
    "color":[0.6,0.8,0.9,1.0],
    "visible":true
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SetGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Group_Group):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SetGroup"
            self.Type = Type
            # The requested group settings.
            self.Input = Input

    class Response:

        """
         Server response for the `SetGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Group_Group, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SetGroup"
            self.Type = Type
            # The requested group settings.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

