from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.Project import Project as MF_V3_Settings_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SetProject:
    """*
    Apply settings to the current open project.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetProject",
    "Input":{
    "name":"My Project"
    },
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetProject",
    "Input":{
    "name":"My Project"
    },
    "Output":{
    "index":5,
    "name":"My Project",
    "groups":[{
    "color":[0.8,0.5,0.6,1.0],
    "index":1,
    "name":"Scan-1",
    "scan":1,
    "rotation":[0.2,0.8,-0.1],
    "translation":[-275,-32,-134],
    "visible":true
    }],
    }
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SetProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Project_Project = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SetProject"
            self.Type = Type
            # Project settings.
            self.Input = Input

    class Response:

        """
         Server response for the `SetProject` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Project_Project = None, Output: MF_V3_Descriptors_Project_Project = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SetProject"
            self.Type = Type
            # Requested project settings.
            self.Input = Input
            # Actual project settings after applying the requested settings.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

