from MF.V3.Descriptors.Settings.Projector import Projector as MF_V3_Descriptors_Settings_Projector_Projector
from MF.V3.Settings.Projector import Projector as MF_V3_Settings_Projector_Projector
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SetProjector:
    """*
    Apply projector settings.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetProjector"
    "Input":{
    "on":true,
    "brightness":0.75,
    "color":[1.0, 1.0, 1.0]
    },
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SetProjector"
    "Input":{
    "on":true,
    "brightness":0.75,
    "color":[1.0, 1.0, 1.0]
    },
    "Output":{
    "on":{"default":false,"value":true},
    "brightness":{"default":0.5,"max":1.0,"min":0.0,"value":0.75}
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SetProjector` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Projector_Projector = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SetProjector"
            self.Type = Type
            # Projector settings.
            self.Input = Input

    class Response:

        """
         Server response for the `SetProjector` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Projector_Projector = None, Output: MF_V3_Descriptors_Settings_Projector_Projector = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SetProjector"
            self.Type = Type
            # Requested projector settings.
            self.Input = Input
            # Actual projector settings after applying the requested settings.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

