from MF.V3.Settings.Smooth import Smooth as MF_V3_Settings_Smooth_Smooth
from MF.V3.Task import TaskState as MF_V3_Task_TaskState
from typing import List


class Smooth:
    """*
    Smooth a set of scans.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Smooth",
    "Input":{
    "selection":{"mode":"visible"},
    "taubin":{"iterations": 3, "lambda": 0.5, "mu": -0.53}
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"Smooth",
    "Input":{
    "selection":{"mode":"visible"},
    "taubin":{"iterations": 3, "lambda": 0.5, "mu": -0.53}
    },
    "Output":{[1, 2, 3]},
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `Smooth` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Smooth_Smooth):
            # A unique identifier generated by the client.
            self.Index = Index
            # "Smooth"
            self.Type = Type
            # The Smooth settings.
            self.Input = Input

    class Response:

        """
         Server response for the `Smooth` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Smooth_Smooth, Output: List[int] = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "Smooth"
            self.Type = Type
            # The requested Smooth settings.
            self.Input = Input
            # The index of each modified scan.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

