from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SplitGroup:
    """*
    Split a scan group (ie. move its subgroups to its parent group).

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SplitGroup",
    "Input":0
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"SplitGroup",
    "Input":0,
    "Output":{
    "groups":[
    {
    "index":1,
    "name":"Group 1",
    },
    {
    "index":2,
    "name":"Group 2"
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SplitGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: int):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SplitGroup"
            self.Type = Type
            # The index of the group to split.
            self.Input = Input

    class Response:

        """
         Server response for the `SplitGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: int, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SplitGroup"
            self.Type = Type
            # The requested index of the group to split.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

