from MF.V3.Settings.Video import Video as MF_V3_Settings_Video_Video
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class StartVideo:
    """*
    Start the video stream.

    The video frames are sent as task buffers associated with the reserved video task index -1.  The left and right camera frames are sent in buffer 0 and 1, respectively.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"StartVideo"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"StartVideo",
    "Output":{
    "codec":"JPEG",
    "format":"YUV420",
    "width":510,
    "height":380
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `StartVideo` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "StartVideo"
            self.Type = Type

    class Response:

        """
         Server response for the `StartVideo` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Settings_Video_Video = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "StartVideo"
            self.Type = Type
            # The video settings.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

