from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class StopVideo:
    """*
    Stop the video stream.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"StopVideo"
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"StopVideo",
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `StopVideo` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "StopVideo"
            self.Type = Type

    class Response:

        """
         Server response for the `StopVideo` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "StopVideo"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

