from MF.V3.Descriptors.System import System as MF_V3_Descriptors_System_System
from MF.V3.Settings.Software import Software as MF_V3_Settings_Software_Software
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class SystemInfo:
    """*
    Get system information including the serial number, disk space and installed and available software versions.

    Request example:
    ```
    {
    "Task":{
    "Index":1,
    "Type":"SystemInfo",
    "Input":{
    "installed":["server","frontend"],
    "available":["server","frontend"]
    }
    }
    }
    ```
    Response example:
    ```
    {
    "Task":{
    "Index":1,
    "Type":"SystemInfo"
    "Input":{
    "installed":["server","frontend"],
    "available":["server","frontend"]
    }
    "Output":{
    "serialNumber":"1000000012345678",
    "diskSpace":{"available":8523210752,"capacity":15082610688},
    "software:{
    "installed":[
    {
    "name":"server",
    "version":{
    "major":2,
    "minor":21,
    "patch":119,
    "string":"2.21.119"
    }
    },
    {
    "name":"frontend",
    "version":{
    "major":2,
    "minor":14,
    "patch":39,
    "string":"2.14.39"
    }
    }
    },
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `SystemInfo` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Software_Software = None):
            # A unique identifier generated by the client.
            self.Index = Index
            # "SystemInfo"
            self.Type = Type
            # Software settings.
            self.Input = Input

    class Response:

        """
         Server response for the `SystemInfo` task.
        """
        def __init__(self, Index: int, Type: str, Output: MF_V3_Descriptors_System_System, Input: MF_V3_Settings_Software_Software = None, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "SystemInfo"
            self.Type = Type
            # The system descriptor.
            self.Output = Output
            # The requested software settings.
            self.Input = Input
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

