from MF.V3.Descriptors.Project import Project as MF_V3_Descriptors_Project_Project
from MF.V3.Settings.Group import Group as MF_V3_Settings_Group_Group
from MF.V3.Task import TaskState as MF_V3_Task_TaskState


class TransformGroup:
    """*
    Apply a rigid transformation to a group.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"TransformGroup",
    "Input":{
    "index":1,
    "rotation":[0.5, 1.0, 1.5],
    "translation":[10, 20, 30]
    }
    }
    }
    ```

    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"TransformGroup",
    "Input":{
    "index":1,
    "rotation":[0.5, 1.0, 1.5],
    "translation":[10, 20, 30]
    },
    "Output":{
    "groups":[
    {
    "index":1,
    "name":"Group 1",
    "rotation":[0.5, 1.0, 1.5],
    "translation":[10, 20, 30]
    }
    ]
    },
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `TransformGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Group_Group):
            # A unique identifier generated by the client.
            self.Index = Index
            # "TransformGroup"
            self.Type = Type
            # The group settings containing the requested rotation and translation.
            self.Input = Input

    class Response:

        """
         Server response for the `TransformGroup` task.
        """
        def __init__(self, Index: int, Type: str, Input: MF_V3_Settings_Group_Group, Output: MF_V3_Descriptors_Project_Project.Group, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "TransformGroup"
            self.Type = Type
            # The group settings containing the requested rotation and translation.
            self.Input = Input
            # The root scan group in the current open project.
            self.Output = Output
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    def __init__(self):
        pass

