from MF.V3.Task import TaskState as MF_V3_Task_TaskState, Task as MF_V3_Task_Task


class UploadProject:
    """*
    Upload a project to the scanner.  The project must be archived in a ZIP file.

    > Request example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"UploadProject"
    }
    }
    ```

    > Buffer message from client.

    ```json
    {
    "Buffer":{
    "Index":0,
    "Size":15682096,
    "Task":{
    "Index":1,
    "Type":"UploadProject"
    }
    }
    }
    ```

    > Binary data transfer from client: The project zip file [15682096 bytes].
    > Response example:

    ```json
    {
    "Task":{
    "Index":1,
    "Type":"UploadProject"
    "State":"Completed"
    }
    }
    ```
    """
    class Request:

        """
         Client request for the `UploadProject` task.
        """
        def __init__(self, Index: int, Type: str):
            # A unique identifier generated by the client.
            self.Index = Index
            # "UploadProject"
            self.Type = Type

    class Response:

        """
         Server response for the `UploadProject` task.
        """
        def __init__(self, Index: int, Type: str, State: MF_V3_Task_TaskState = None, Error: str = None):
            # The unique identifier generated by the client.
            self.Index = Index
            # "UploadProject"
            self.Type = Type
            # The current state of the task.
            self.State = State
            # A string describing the error if the task has failed.
            self.Error = Error

    class Buffer:

        """
         Client buffer message for the `UploadProject` task.
        """
        def __init__(self, Index: int, Size: int, Task: MF_V3_Task_Task):
            # The zero-based index identifying the data buffer.
            self.Index = Index
            # The size of the incoming data buffer in bytes.
            self.Size = Size
            # The requested UploadProject task.
            self.Task = Task

    def __init__(self):
        pass

