# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# This file is Auto Generated by generateScannerPy.py. Do not edit this file manually.
# Modifications should be made to _scanner.py and then run generateScannerPy.py to update this file.
# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

## @package three
# @file scanner.py
# @brief Scanner class to wrap websocket connection. This file will be copied and amended with the three methods.
# @date 2024-11-27
# @copyright © 2024 Matter and Form. All rights reserved.

from MF.V3 import Three
from MF.V3.Task import Task
from MF.V3.Settings.Align import Align
from MF.V3.Settings.AutoFocus import AutoFocus
from MF.V3.Settings.ScanSelection import ScanSelection
from MF.V3.Settings.CaptureImage import CaptureImage
from MF.V3.Settings.Camera import Camera
from MF.V3.Settings.Projector import Projector
from MF.V3.Settings.Turntable import Turntable
from MF.V3.Settings.Capture import Capture
from MF.V3.Settings.Scan import Scan
from MF.V3.Settings.Export import Export
from MF.V3.Settings.Import import Import
from MF.V3.Settings.Merge import Merge
from MF.V3.Settings.ScanData import ScanData
from MF.V3.Settings.Smooth import Smooth
from MF.V3.Settings.Advanced import Advanced
from MF.V3.Settings.I18n import I18n
from MF.V3.Settings.Style import Style
from MF.V3.Settings.Tutorials import Tutorials
from MF.V3.Settings.Viewer import Viewer
from MF.V3.Settings.Software import Software

from typing import Any, Callable, Optional, List
import websocket
import json
import threading
import time
from MF.V3 import Task, TaskState, Buffer
from three import __version__
import three.MF
from three.serialization import TO_JSON
from three.MF.V3.Buffer import Buffer




class Scanner:
    """
    Main class to manage and communicate with the Matter and Form THREE 3D Scanner via websocket.

    Attributes:
        * OnTask (Optional[Callable[[Task], None]]): Callback for any task related messages, default is None. Will fire for task complete, progress, and error.
        * OnMessage (Optional[Callable[[str], None]]): Callback function to handle messages, default is None. Messages are any calls related to the system that are not tasks or buffers. Eg. {"Message":{"HasTurntable":true}}
        * OnBuffer (Optional[Callable[[Any, bytes], None]]): Callback Function to handle buffer data, default is None. Buffers can be image or scan data. These are binary formats that are sent separately from tasks. Buffers will contain a header that describes the buffer data size. Please note that websocket buffers are limited in size and need to be sent in chunks.
    """
    
    __bufferDescriptor = None
    __buffer = None
    __error = None
    __taskIndex:int = 0
    __tasks:List[Task] = []


    def __init__(self,
        OnTask: Optional[Callable[[Task], None]] = None,
        OnMessage: Optional[Callable[[str], None]] = None,
        OnBuffer: Optional[Callable[[Any, bytes], None]] = None,
        ):
        """
        Initializes the Scanner object.

        Args:
            * OnTask (Optional[Callable[[Task], None]]): Callback for any task related messages, default is None. Will fire for task complete, progress, and error.
            * OnMessage (Optional[Callable[[str], None]]): Callback function to handle messages, default is None. Messages are any calls related to the system that are not tasks or buffers. Eg. {"Message":{"HasTurntable":true}}
            * OnBuffer (Optional[Callable[[Any, bytes], None]]): Callback Function to handle buffer data, default is None. Buffers can be image or scan data. These are binary formats that are sent separately from tasks. Buffers will contain a header that describes the buffer data size. Please note that websocket buffers are limited in size and need to be sent in chunks.
        """
        self.__isConnected = False

        self.OnTask = OnTask
        self.OnMessage = OnMessage
        self.OnBuffer = OnBuffer
        
        self.__task_return_event = threading.Event()
        
        # Dynamically add methods from Three to Scanner
        # self._add_three_methods()

    # def _add_three_methods(self):
    #     """
    #     Dynamically adds functions from the three_methods module to the Scanner class.
    #     """
    #     for name, func in inspect.getmembers(Three, predicate=inspect.isfunction):
    #         if not name.startswith('_'):
    #             setattr(self, name, func.__get__(self, self.__class__))


    def Connect(self, URI:str, timeoutSec=5) -> bool:
        """
        Attempts to connect to the scanner using the specified URI and timeout.

        Args:
            * URI (str): The URI of the websocket server.
            * timeoutSec (int): Timeout in seconds, default is 5.

        Returns:
            bool: True if connection is successful, raises Exception otherwise.

        Raises:
            Exception: If connection fails within the timeout or due to an error.
        """
        print('Connecting to: ', URI)
        self.__URI = URI
        self.__isConnected = False
        self.__error = None

        self.__serverVersion__= None

        self.websocket = websocket.WebSocketApp(self.__URI,
                              on_open=self.__OnOpen,
                              on_close=self.__OnClose,
                              on_error=self.__OnError,
                              on_message=self.__OnMessage,
                              )
        
        wst = threading.Thread(target=self.websocket.run_forever)
        wst.daemon = True
        wst.start()

        # Wait for connection
        start = time.time()
        while time.time() < start + timeoutSec:
            if self.__isConnected:
                # Not checking versions => return True
                    return True
            elif self.__error:
                raise Exception(self.__error)
            time.sleep(0.1)
        
        raise Exception('Connection timeout')
        
    def Disconnect(self) -> None:
        """
        Close the websocket connection.
        """
        if self.__isConnected:
            # Close the connection
            self.websocket.close()
            # Wait for the connection to be closed.
            while self.__isConnected:
                time.sleep(0.1)

    def IsConnected(self)-> bool:
        """
        Checks if the scanner is currently connected.

        Returns:
            bool: True if connected, False otherwise.
        """
        return self.__isConnected
    
    def __callback(self, callback, *args) -> None:
        if callback:
                callback(self, *args)

    # Called when the connection is opened
    def __OnOpen(self, ws) -> None:
        """
        Callback function for when the websocket connection is successfully opened.

        Prints a success message to the console.

        Args:
            ws: The websocket object.
        """
        self.__isConnected = True
        print('Connected to: ', self.__URI)

    # Called when the connection is closed
    def __OnClose(self, ws, close_status_code, close_msg):
        """
        Callback function for when the websocket connection is closed.

        Prints a disconnect message to the console.

        Args:
            ws: The websocket object.
            close_status_code: The code indicating why the websocket was closed.
            close_msg: Additional message about why the websocket was closed.
        """
        if self.__isConnected:
            print('Disconnected')
        self.__isConnected = False

    # Called when an error happens
    def __OnError(self, ws, error) -> None:
        """
        Callback function for when an error occurs in the websocket connection.

        Prints an error message to the console and stores the error for reference.

        Args:
            ws: The websocket object.
            error: The error that occurred.
        """
        if self.__isConnected:
            print('Error: ', error)    
        else:
            self.__error = error
        
    # Called when a message arrives on the connection
    def __OnMessage(self, ws, message) -> None:
        """
        Callback function for handling messages received via the websocket.

        Determines the type of message received (Task, Buffer, or general Message) and
        triggers the corresponding handler function if one is set.

        Args:
            ws: The websocket object.
            message: The raw message received, which can be either a byte string or a JSON string.
        """
        # Bytes ?
        if isinstance(message, bytes):
            if self.OnBuffer:
                
                if self.__buffer:
                    self.__buffer += message
                else:
                    self.__buffer = message
                if self.__bufferDescriptor.Size == len(self.__buffer):
                    self.OnBuffer(self.__bufferDescriptor, message)
                    self.__bufferDescriptor = None 
                    self.__buffer = None
        else:
            obj = json.loads(message)              
        
            # Task
            if 'Task' in obj:
                # Create the task from the message
                task = Task(**obj['Task'])
                
                if (task.Progress):
                    # Extract the first (and only) item from the task.Progress dictionary
                    # TODO Duct tape fix due to schema weirdness for progress
                    key, process = next(iter(task.Progress.items()))
                    task.Progress = type('Progress', (object,), {
                        'current': process["current"],
                        'step': process["step"],
                        'total': process["total"]
                    })()

                # Find the original task for reference
                inputTask = self.__FindTaskWithIndex(task.Index)
                if inputTask == None:
                    raise Exception('Task not found')
                    
                if task.Error:
                    inputTask.Error = task.Error
                    self.__OnError(self.websocket, task.Error)
                    self.__task_return_event.set()
                    
                # If assigned => Call the handler
                if self.OnTask:
                    self.OnTask(task)
                
                
                # If waiting for a response, set the response and notify
                if (task.State == TaskState.Completed.value):
                    if task.Output:
                        inputTask.Output = task.Output
                    self.__task_return_event.set()
                elif (task.State == TaskState.Failed.value):
                    inputTask.Error = task.Error
                    self.__task_return_event
                    
            # Buffer
            elif 'Buffer' in obj:
                self.__bufferDescriptor = Buffer(**obj['Buffer'])
                self.__buffer = None    
            # Message
            elif 'Message' in obj:
                if self.OnMessage:
                    self.OnMessage(obj)

    def SendTask(self, task, buffer:bytes = None) -> Any:
        """
        Sends a task to the scanner.
        Tasks are general control requests for the scanner. (eg. Camera exposure, or Get Image)

        Creates a task, serializes it, and sends it via the websocket.

        Args:
            * task (Task): The task to send.
            * buffer (bytes): The buffer data to send, default is None.

        Returns:
            Any: The task object that was sent.

        Raises:
            AssertionError: If the connection is not established.
        """
        assert self.__isConnected

        # Update the index
        task.Index = self.__taskIndex
        task.Input.Index = self.__taskIndex
        self.__taskIndex += 1

        # Send the task
        self.__task_return_event.clear()
        
        # Append the task
        self.__tasks.append(task)

        if buffer == None:
            self.__SendTask(task)
        else:
            self.__SendTaskWithBuffer(task, buffer)

        if task.Output:
            # Wait for response
            self.__task_return_event.wait()

        self.__tasks.remove(task)

        return task
    
    # Send a task to the scanner
    def __SendTask(self, task):
        assert self.__isConnected

        # Serialize the task
        message = TO_JSON(task.Input)
        
        # Build and send the message
        message = '{"Task":' + message + '}'
        print('Message: ', message)

        self.websocket.send(message)

    # Send a task with its buffer to the scanner
    def __SendTaskWithBuffer(self, task:Task, buffer:bytes):
        assert self.__isConnected

        # Send the task
        self.__SendTask(task)

        # Build the buffer descriptor
        bufferSize = len(buffer)
        bufferDescriptor = Buffer(0, bufferSize, task)

        # Serialize the buffer descriptor
        bufferMessage = TO_JSON(bufferDescriptor)

        # Send the buffer descriptor
        bufferMessage = '{"Buffer":' + bufferMessage + '}'
        self.websocket.send(bufferMessage)

        # The maximum websocket payload size is 32 MB.
        MAX_SIZE = 32000000
        sentSize = 0

        # Send all the sub-payloads of the maximum payload size.
        while sentSize + MAX_SIZE < bufferSize:
            self.websocket.send(buffer[sentSize:sentSize + MAX_SIZE], websocket.ABNF.OPCODE_BINARY)
            sentSize += MAX_SIZE

        # Send the remaining data.
        if sentSize < bufferSize:
            self.websocket.send(buffer[sentSize:bufferSize], websocket.ABNF.OPCODE_BINARY)
    
    def __FindTaskWithIndex(self, index:int) -> Task:
        # Find the task in the list
        for i, t in enumerate(self.__tasks):
            if t.Index == index:
                return t
                break
        return None

    # Dynamically bound functions from three.py

    def add_merge_to_project(self) -> 'Task':
        """Add a merged scan to the current project."""
        return Three.add_merge_to_project(self)

    def align(self, source: 'int', target: 'int', rough: 'Align.Rough' = None, fine: 'Align.Fine' = None) -> 'Task':
        """Align two scan groups."""
        return Three.align(self, source, target, rough, fine)

    def auto_focus(self, applyAll: 'bool', cameras: 'list[AutoFocus.Camera]' = None) -> 'Task':
        """Auto focus one or both cameras."""
        return Three.auto_focus(self, applyAll, cameras)

    def bounding_box(self, selection: 'ScanSelection', axisAligned: 'bool') -> 'Task':
        """Get the bounding box of a set of scan groups."""
        return Three.bounding_box(self, selection, axisAligned)

    def calibrate_cameras(self) -> 'Task':
        """Calibrate the cameras."""
        return Three.calibrate_cameras(self)

    def calibrate_turntable(self) -> 'Task':
        """Calibrate the turntable."""
        return Three.calibrate_turntable(self)

    def calibration_capture_targets(self) -> 'Task':
        """Get the calibration capture target for each camera calibration capture."""
        return Three.calibration_capture_targets(self)

    def camera_calibration(self) -> 'Task':
        """Get the camera calibration descriptor."""
        return Three.camera_calibration(self)

    def capture_image(self, selection: 'list[int]' = None, codec: 'CaptureImage.Codec' = None, grayscale: 'bool' = None) -> 'Task':
        """Capture a single Image."""
        return Three.capture_image(self, selection, codec, grayscale)

    def clear_settings(self) -> 'Task':
        """Clear scanner settings and restore the default values."""
        return Three.clear_settings(self)

    def close_project(self) -> 'Task':
        """Close the current open project."""
        return Three.close_project(self)

    def connect_wifi(self, ssid: 'str', password: 'str') -> 'Task':
        """Connect to a wifi network."""
        return Three.connect_wifi(self, ssid, password)

    def copy_groups(self, sourceIndexes: 'list[int]' = None, targetIndex: 'int' = None, childPosition: 'int' = None, nameSuffix: 'str' = None, enumerate: 'bool' = None) -> 'Task':
        """Copy a set of scan groups in the current open project."""
        return Three.copy_groups(self, sourceIndexes, targetIndex, childPosition, nameSuffix, enumerate)

    def depth_map(self, camera: 'Camera' = None, projector: 'Projector' = None, turntable: 'Turntable' = None, capture: 'Capture' = None, processing: 'Scan.Processing' = None, alignWithScanner: 'bool' = None, centerAtOrigin: 'bool' = None) -> 'Task':
        """Capture a depth map."""
        return Three.depth_map(self, camera, projector, turntable, capture, processing, alignWithScanner, centerAtOrigin)

    def detect_calibration_card(self, Input: 'int') -> 'Task':
        """Detect the calibration card on one or both cameras."""
        return Three.detect_calibration_card(self, Input)

    def download_project(self, Input: 'int') -> 'Task':
        """Download a project from the scanner."""
        return Three.download_project(self, Input)

    def export(self, selection: 'ScanSelection' = None, texture: 'bool' = None, merge: 'bool' = None, format: 'Export.Format' = None, scale: 'float' = None, color: 'Export.Color' = None) -> 'Task':
        """Export a group of scans."""
        return Three.export(self, selection, texture, merge, format, scale, color)

    def export_factory_calibration_logs(self) -> 'Task':
        """Export factory calibration logs."""
        return Three.export_factory_calibration_logs(self)

    def export_heat_map(self, selection: 'ScanSelection' = None, texture: 'bool' = None, merge: 'bool' = None, format: 'Export.Format' = None, scale: 'float' = None, color: 'Export.Color' = None) -> 'Task':
        """Export a mesh with vertex colors generated by the 'HeatMap' task."""
        return Three.export_heat_map(self, selection, texture, merge, format, scale, color)

    def export_logs(self, Input: 'bool' = None) -> 'Task':
        """Export scanner logs."""
        return Three.export_logs(self, Input)

    def export_merge(self, selection: 'ScanSelection' = None, texture: 'bool' = None, merge: 'bool' = None, format: 'Export.Format' = None, scale: 'float' = None, color: 'Export.Color' = None) -> 'Task':
        """Export a merged scan."""
        return Three.export_merge(self, selection, texture, merge, format, scale, color)

    def factory_reset(self) -> 'Task':
        """Reset the scanner to factory settings."""
        return Three.factory_reset(self)

    def flatten_group(self, Input: 'int') -> 'Task':
        """Flatten a scan group such that it only consists of single scans."""
        return Three.flatten_group(self, Input)

    def forget_wifi(self) -> 'Task':
        """Forget all wifi connections."""
        return Three.forget_wifi(self)

    def has_cameras(self) -> 'Task':
        """Check if the scanner has working cameras."""
        return Three.has_cameras(self)

    def has_projector(self) -> 'Task':
        """Check if the scanner has a working projector."""
        return Three.has_projector(self)

    def has_turntable(self) -> 'Task':
        """Check if the scanner is connected to a working turntable."""
        return Three.has_turntable(self)

    def heat_map(self, sources: 'list[int]' = None, targets: 'list[int]' = None, outlierDistance: 'float' = None) -> 'Task':
        """Compute the point-to-mesh distances of a source mesh to a target mesh and visualize as a heat map."""
        return Three.heat_map(self, sources, targets, outlierDistance)

    def import_file(self, name: 'str' = None, scale: 'float' = None, unit: 'Import.Unit' = None, center: 'bool' = None, groupIndex: 'int' = None) -> 'Task':
        """Import a set of 3D meshes to the current open project.  The meshes must be archived in a ZIP file."""
        return Three.import_file(self, name, scale, unit, center, groupIndex)

    def list_export_formats(self) -> 'Task':
        """List all export formats."""
        return Three.list_export_formats(self)

    def list_groups(self) -> 'Task':
        """List the scan groups in the current open project."""
        return Three.list_groups(self)

    def list_network_interfaces(self) -> 'Task':
        """List available wifi networks."""
        return Three.list_network_interfaces(self)

    def list_projects(self) -> 'Task':
        """List all projects."""
        return Three.list_projects(self)

    def list_scans(self) -> 'Task':
        """List the scans in the current open project."""
        return Three.list_scans(self)

    def list_settings(self) -> 'Task':
        """Get scanner settings."""
        return Three.list_settings(self)

    def list_wifi(self) -> 'Task':
        """List available wifi networks."""
        return Three.list_wifi(self)

    def merge(self, selection: 'ScanSelection' = None, remesh: 'Merge.Remesh' = None, simplify: 'Merge.Simplify' = None, texturize: 'bool' = None) -> 'Task':
        """Merge two or more scan groups."""
        return Three.merge(self, selection, remesh, simplify, texturize)

    def merge_data(self, index: 'int', mergeStep: 'ScanData.MergeStep' = None, buffers: 'list[ScanData.Buffer]' = None, metadata: 'list[ScanData.Metadata]' = None) -> 'Task':
        """Download the raw scan data for the current merge process."""
        return Three.merge_data(self, index, mergeStep, buffers, metadata)

    def move_group(self, Input: 'list[int]' = None) -> 'Task':
        """Move a scan group."""
        return Three.move_group(self, Input)

    def new_group(self, parentIndex: 'int' = None, baseName: 'str' = None, color: 'list[float]' = None, visible: 'bool' = None, collapsed: 'bool' = None, rotation: 'list[float]' = None, translation: 'list[float]' = None) -> 'Task':
        """Create a new scan group."""
        return Three.new_group(self, parentIndex, baseName, color, visible, collapsed, rotation, translation)

    def new_project(self, Input: 'str' = None) -> 'Task':
        """Create a new project."""
        return Three.new_project(self, Input)

    def new_scan(self, camera: 'Camera' = None, projector: 'Projector' = None, turntable: 'Turntable' = None, capture: 'Capture' = None, processing: 'Scan.Processing' = None, alignWithScanner: 'bool' = None, centerAtOrigin: 'bool' = None) -> 'Task':
        """Capture a new scan."""
        return Three.new_scan(self, camera, projector, turntable, capture, processing, alignWithScanner, centerAtOrigin)

    def open_project(self, Input: 'int') -> 'Task':
        """Open an existing project."""
        return Three.open_project(self, Input)

    def pop_settings(self, Input: 'bool' = None) -> 'Task':
        """Pop and restore scanner settings from the settings stack."""
        return Three.pop_settings(self, Input)

    def push_settings(self) -> 'Task':
        """Push the current scanner settings to the settings stack."""
        return Three.push_settings(self)

    def reboot(self) -> 'Task':
        """Reboot the scanner."""
        return Three.reboot(self)

    def remove_groups(self, Input: 'list[int]' = None) -> 'Task':
        """Remove selected scan groups."""
        return Three.remove_groups(self, Input)

    def remove_projects(self, Input: 'list[int]' = None) -> 'Task':
        """Remove selected projects."""
        return Three.remove_projects(self, Input)

    def restore_factory_calibration(self) -> 'Task':
        """Restore factory calibration."""
        return Three.restore_factory_calibration(self)

    def rotate_turntable(self, Input: 'int') -> 'Task':
        """Rotate the turntable."""
        return Three.rotate_turntable(self, Input)

    def scan_data(self, index: 'int', mergeStep: 'ScanData.MergeStep' = None, buffers: 'list[ScanData.Buffer]' = None, metadata: 'list[ScanData.Metadata]' = None) -> 'Task':
        """Download the raw scan data for a scan in the current open project."""
        return Three.scan_data(self, index, mergeStep, buffers, metadata)

    def set_cameras(self, selection: 'list[int]' = None, autoExposure: 'bool' = None, exposure: 'int' = None, analogGain: 'float' = None, digitalGain: 'int' = None, focus: 'int' = None) -> 'Task':
        """Apply camera settings to one or both cameras."""
        return Three.set_cameras(self, selection, autoExposure, exposure, analogGain, digitalGain, focus)

    def set_group(self, index: 'int', name: 'str' = None, color: 'list[float]' = None, visible: 'bool' = None, collapsed: 'bool' = None, rotation: 'list[float]' = None, translation: 'list[float]' = None) -> 'Task':
        """Set scan group properties."""
        return Three.set_group(self, index, name, color, visible, collapsed, rotation, translation)

    def set_project(self, index: 'int' = None, name: 'str' = None) -> 'Task':
        """Apply settings to the current open project."""
        return Three.set_project(self, index, name)

    def set_projector(self, on: 'bool' = None, brightness: 'float' = None, pattern: 'Projector.Pattern' = None, image: 'Projector.Image' = None, color: 'list[float]' = None, buffer: 'bytes' = None) -> 'Task':
        """Apply projector settings."""
        return Three.set_projector(self, on, brightness, pattern, image, color, buffer)

    def shutdown(self) -> 'Task':
        """Shutdown the scanner."""
        return Three.shutdown(self)

    def smooth(self, selection: 'ScanSelection' = None, taubin: 'Smooth.Taubin' = None) -> 'Task':
        """Smooth a set of scans."""
        return Three.smooth(self, selection, taubin)

    def split_group(self, Input: 'int') -> 'Task':
        """Split a scan group (ie. move its subgroups to its parent group)."""
        return Three.split_group(self, Input)

    def start_video(self) -> 'Task':
        """Start the video stream."""
        return Three.start_video(self)

    def stop_video(self) -> 'Task':
        """Stop the video stream."""
        return Three.stop_video(self)

    def system_info(self, updateMajor: 'bool' = None, updateNightly: 'bool' = None) -> 'Task':
        """Get system information."""
        return Three.system_info(self, updateMajor, updateNightly)

    def transform_group(self, index: 'int', name: 'str' = None, color: 'list[float]' = None, visible: 'bool' = None, collapsed: 'bool' = None, rotation: 'list[float]' = None, translation: 'list[float]' = None) -> 'Task':
        """Apply a rigid transformation to a group."""
        return Three.transform_group(self, index, name, color, visible, collapsed, rotation, translation)

    def turntable_calibration(self) -> 'Task':
        """Get the turntable calibration descriptor."""
        return Three.turntable_calibration(self)

    def update_settings(self, advanced: 'Advanced' = None, camera: 'Camera' = None, capture: 'Capture' = None, i18n: 'I18n' = None, projector: 'Projector' = None, style: 'Style' = None, turntable: 'Turntable' = None, tutorials: 'Tutorials' = None, viewer: 'Viewer' = None, software: 'Software' = None) -> 'Task':
        """Update scanner settings."""
        return Three.update_settings(self, advanced, camera, capture, i18n, projector, style, turntable, tutorials, viewer, software)

    def upload_project(self, buffer: 'bytes') -> 'Task':
        """Upload a project to the scanner."""
        return Three.upload_project(self, buffer)
