"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BudiBaseBaseResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_ec2_1 = require("aws-cdk-lib/aws-ec2");
const constructs_1 = require("constructs");
class BudiBaseBaseResource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const vpc = new aws_cdk_lib_1.aws_ec2.Vpc(this, 'BudiBaseVpc', {
            natGateways: 1,
        }) ?? props?.vpc;
        const budiBaseSG = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'BudiBaseSG', {
            securityGroupName: 'BudiBaseFargateService',
            vpc,
        });
        aws_cdk_lib_1.Tags.of(budiBaseSG).add('Name', 'BudiBaseFargateService');
        const budiBaselbSG = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'budiBaselbSG', {
            securityGroupName: 'BudiBaseLoadBalancer',
            vpc,
        });
        aws_cdk_lib_1.Tags.of(budiBaselbSG).add('Name', 'BudiBaseLoadBalancer');
        /**
         * EFS
         */
        const budiBaseFileSystem = new aws_cdk_lib_1.aws_efs.FileSystem(this, 'BudiBaseFileSystem', {
            fileSystemName: 'BudiBaseFileSystem',
            vpc,
            vpcSubnets: {
                subnetType: aws_ec2_1.SubnetType.PRIVATE_WITH_EGRESS,
            },
            enableAutomaticBackups: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
        });
        const accessPoint = new aws_cdk_lib_1.aws_efs.AccessPoint(this, 'BudiBaseAccessPoint', {
            fileSystem: budiBaseFileSystem,
            path: '/data',
            createAcl: {
                ownerGid: '1001',
                ownerUid: '1001',
                permissions: '0755',
            },
            posixUser: {
                uid: '1001',
                gid: '1001',
            },
        });
        /**
         * ECS Cluster
         */
        const cluster = new aws_cdk_lib_1.aws_ecs.Cluster(this, 'BudiBaseCluster', {
            clusterName: 'BudiBaseCluster',
            vpc,
        });
        /**
         * ECS Service
         */
        const fargateTaskDefinition = new aws_cdk_lib_1.aws_ecs.FargateTaskDefinition(this, 'BudiBaseTaskDefinition', {
            family: 'budibase-family',
            memoryLimitMiB: 8192,
            cpu: 4096,
        });
        const budiBaseContainer = fargateTaskDefinition.addContainer('BudiBaseContainer', {
            containerName: 'budibase',
            image: aws_cdk_lib_1.aws_ecs.ContainerImage.fromRegistry('budibase/budibase:v2.2.23'),
            portMappings: [
                {
                    containerPort: 80,
                    hostPort: 80,
                },
                {
                    containerPort: 443,
                    hostPort: 443,
                },
                {
                    containerPort: 2222,
                    hostPort: 2222,
                },
                {
                    containerPort: 4369,
                    hostPort: 4369,
                },
                {
                    containerPort: 5984,
                    hostPort: 5984,
                },
                {
                    containerPort: 9100,
                    hostPort: 9100,
                },
            ],
            logging: new aws_cdk_lib_1.aws_ecs.AwsLogDriver({
                streamPrefix: 'budibase',
                logGroup: new aws_cdk_lib_1.aws_logs.LogGroup(this, 'BudibaseContainerLogGroup', {
                    logGroupName: 'budibase',
                    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                }),
            }),
            // entryPoint: [''],
            // command: ['tail', '-f', '/dev/null'],
            healthCheck: {
                startPeriod: aws_cdk_lib_1.Duration.seconds(75),
                command: ['CMD-SHELL', '/healthcheck.sh'],
            },
        });
        const volume = {
            name: 'budibase-data-volume',
            efsVolumeConfiguration: {
                fileSystemId: budiBaseFileSystem.fileSystemId,
                /**
                 * When using an EFS access point, the root directory must either be set to "/" or be omitted.
                 */
                // rootDirectory: '/',
                authorizationConfig: {
                    accessPointId: accessPoint.accessPointId,
                    // iam: 'ENABLED',
                },
                transitEncryption: 'ENABLED',
            },
        };
        budiBaseContainer.addMountPoints({
            sourceVolume: 'budibase-data-volume',
            containerPath: '/data',
            readOnly: false,
        });
        fargateTaskDefinition.addVolume(volume);
        const budiBaseService = new aws_cdk_lib_1.aws_ecs.FargateService(this, 'BudiBaseService', {
            serviceName: 'budibase',
            taskDefinition: fargateTaskDefinition,
            cluster,
            vpcSubnets: {
                subnetType: aws_ec2_1.SubnetType.PRIVATE_WITH_EGRESS,
            },
            enableExecuteCommand: true,
            platformVersion: aws_cdk_lib_1.aws_ecs.FargatePlatformVersion.VERSION1_4,
            securityGroups: [budiBaseSG],
        });
        fargateTaskDefinition.addToExecutionRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            actions: [
                'elasticfilesystem:ClientMount',
                'elasticfilesystem:ClientWrite',
                'elasticfilesystem:ClientRootAccess',
                'elasticfilesystem:DescribeMountTargets',
            ],
            resources: [
                accessPoint.fileSystem.fileSystemArn,
            ],
        }));
        budiBaseService.node.addDependency(accessPoint.fileSystem.mountTargetsAvailable);
        budiBaseFileSystem.connections.allowFrom(budiBaseService, aws_cdk_lib_1.aws_ec2.Port.tcp(2049));
        /**
         * Load Balancer
         */
        const lb = new aws_cdk_lib_1.aws_elasticloadbalancingv2.ApplicationLoadBalancer(this, 'budibase-lb', {
            loadBalancerName: 'BudibaseLoadBalancer',
            vpc,
            vpcSubnets: {
                subnetType: aws_ec2_1.SubnetType.PUBLIC,
            },
            internetFacing: true,
            securityGroup: budiBaselbSG,
        });
        /**
         * 定義 80 port listener.
         */
        // lb.addListener('Listener80', {
        //   port: 80,
        //   open: false,
        //   defaultAction: elbv2.ListenerAction.redirect({
        //     protocol: 'HTTPS',
        //     host: '#{host}',
        //     path: '/#{path}',
        //     query: '/#{query}',
        //     port: '443',
        //   }),
        // });
        // const listener443 = lb.addListener('Listener443', {
        //   port: 443,
        //   open: false,
        //   certificates: [certificatemanager.Certificate.fromCertificateArn(this, 'ca', '')],
        //   defaultAction: elbv2.ListenerAction.fixedResponse(404),
        // });
        const listener80 = lb.addListener('Listener80', {
            port: 80,
            open: true,
        });
        listener80.addTargets('listener80', {
            port: 80,
            targets: [budiBaseService],
            healthCheck: {
                path: '/',
                healthyHttpCodes: '200-299,301-302',
                interval: aws_cdk_lib_1.Duration.seconds(30),
            },
        });
        new aws_cdk_lib_1.CfnOutput(this, 'LoadBalancerDNS', {
            value: lb.loadBalancerDnsName,
        });
        new aws_cdk_lib_1.CfnOutput(this, 'BudiBaselbSGId', {
            value: budiBaselbSG.securityGroupId,
        });
    }
}
exports.BudiBaseBaseResource = BudiBaseBaseResource;
_a = JSII_RTTI_SYMBOL_1;
BudiBaseBaseResource[_a] = { fqn: "cdk-budibase.BudiBaseBaseResource", version: "0.0.764" };
//# sourceMappingURL=data:application/json;base64,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