# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BuildxBuilderArgs', 'BuildxBuilder']

@pulumi.input_type
class BuildxBuilderArgs:
    def __init__(__self__, *,
                 append: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 buildkit_config: Optional[pulumi.Input[_builtins.str]] = None,
                 buildkit_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_container: Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input['BuildxBuilderKubernetesArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 remote: Optional[pulumi.Input['BuildxBuilderRemoteArgs']] = None,
                 use: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a BuildxBuilder resource.
        :param pulumi.Input[_builtins.bool] append: Append a node to builder instead of changing it
        :param pulumi.Input[_builtins.bool] bootstrap: Automatically boot the builder after creation. Defaults to `false`
        :param pulumi.Input[_builtins.str] buildkit_config: BuildKit daemon config file
        :param pulumi.Input[_builtins.str] buildkit_flags: BuildKit flags to set for the builder.
        :param pulumi.Input['BuildxBuilderDockerContainerArgs'] docker_container: Configuration block for the Docker-Container driver.
        :param pulumi.Input[_builtins.str] driver: The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] driver_options: Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        :param pulumi.Input['BuildxBuilderKubernetesArgs'] kubernetes: Configuration block for the Kubernetes driver.
        :param pulumi.Input[_builtins.str] name: The name of the Buildx builder. IF not specified, a random name will be generated.
        :param pulumi.Input[_builtins.str] node: Create/modify node with given name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: Fixed platforms for current node
        :param pulumi.Input['BuildxBuilderRemoteArgs'] remote: Configuration block for the Remote driver.
        :param pulumi.Input[_builtins.bool] use: Set the current builder instance as the default for the current context.
        """
        if append is not None:
            pulumi.set(__self__, "append", append)
        if bootstrap is not None:
            pulumi.set(__self__, "bootstrap", bootstrap)
        if buildkit_config is not None:
            pulumi.set(__self__, "buildkit_config", buildkit_config)
        if buildkit_flags is not None:
            pulumi.set(__self__, "buildkit_flags", buildkit_flags)
        if docker_container is not None:
            pulumi.set(__self__, "docker_container", docker_container)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)
        if use is not None:
            pulumi.set(__self__, "use", use)

    @_builtins.property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Append a node to builder instead of changing it
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "append", value)

    @_builtins.property
    @pulumi.getter
    def bootstrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically boot the builder after creation. Defaults to `false`
        """
        return pulumi.get(self, "bootstrap")

    @bootstrap.setter
    def bootstrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bootstrap", value)

    @_builtins.property
    @pulumi.getter(name="buildkitConfig")
    def buildkit_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BuildKit daemon config file
        """
        return pulumi.get(self, "buildkit_config")

    @buildkit_config.setter
    def buildkit_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buildkit_config", value)

    @_builtins.property
    @pulumi.getter(name="buildkitFlags")
    def buildkit_flags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BuildKit flags to set for the builder.
        """
        return pulumi.get(self, "buildkit_flags")

    @buildkit_flags.setter
    def buildkit_flags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buildkit_flags", value)

    @_builtins.property
    @pulumi.getter(name="dockerContainer")
    def docker_container(self) -> Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']]:
        """
        Configuration block for the Docker-Container driver.
        """
        return pulumi.get(self, "docker_container")

    @docker_container.setter
    def docker_container(self, value: Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']]):
        pulumi.set(self, "docker_container", value)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver", value)

    @_builtins.property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        """
        return pulumi.get(self, "driver_options")

    @driver_options.setter
    def driver_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "driver_options", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['BuildxBuilderKubernetesArgs']]:
        """
        Configuration block for the Kubernetes driver.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['BuildxBuilderKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Buildx builder. IF not specified, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create/modify node with given name
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fixed platforms for current node
        """
        return pulumi.get(self, "platforms")

    @platforms.setter
    def platforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "platforms", value)

    @_builtins.property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['BuildxBuilderRemoteArgs']]:
        """
        Configuration block for the Remote driver.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['BuildxBuilderRemoteArgs']]):
        pulumi.set(self, "remote", value)

    @_builtins.property
    @pulumi.getter
    def use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the current builder instance as the default for the current context.
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use", value)


@pulumi.input_type
class _BuildxBuilderState:
    def __init__(__self__, *,
                 append: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 buildkit_config: Optional[pulumi.Input[_builtins.str]] = None,
                 buildkit_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_container: Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input['BuildxBuilderKubernetesArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 remote: Optional[pulumi.Input['BuildxBuilderRemoteArgs']] = None,
                 use: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering BuildxBuilder resources.
        :param pulumi.Input[_builtins.bool] append: Append a node to builder instead of changing it
        :param pulumi.Input[_builtins.bool] bootstrap: Automatically boot the builder after creation. Defaults to `false`
        :param pulumi.Input[_builtins.str] buildkit_config: BuildKit daemon config file
        :param pulumi.Input[_builtins.str] buildkit_flags: BuildKit flags to set for the builder.
        :param pulumi.Input['BuildxBuilderDockerContainerArgs'] docker_container: Configuration block for the Docker-Container driver.
        :param pulumi.Input[_builtins.str] driver: The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] driver_options: Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        :param pulumi.Input['BuildxBuilderKubernetesArgs'] kubernetes: Configuration block for the Kubernetes driver.
        :param pulumi.Input[_builtins.str] name: The name of the Buildx builder. IF not specified, a random name will be generated.
        :param pulumi.Input[_builtins.str] node: Create/modify node with given name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: Fixed platforms for current node
        :param pulumi.Input['BuildxBuilderRemoteArgs'] remote: Configuration block for the Remote driver.
        :param pulumi.Input[_builtins.bool] use: Set the current builder instance as the default for the current context.
        """
        if append is not None:
            pulumi.set(__self__, "append", append)
        if bootstrap is not None:
            pulumi.set(__self__, "bootstrap", bootstrap)
        if buildkit_config is not None:
            pulumi.set(__self__, "buildkit_config", buildkit_config)
        if buildkit_flags is not None:
            pulumi.set(__self__, "buildkit_flags", buildkit_flags)
        if docker_container is not None:
            pulumi.set(__self__, "docker_container", docker_container)
        if driver is not None:
            pulumi.set(__self__, "driver", driver)
        if driver_options is not None:
            pulumi.set(__self__, "driver_options", driver_options)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if kubernetes is not None:
            pulumi.set(__self__, "kubernetes", kubernetes)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if platforms is not None:
            pulumi.set(__self__, "platforms", platforms)
        if remote is not None:
            pulumi.set(__self__, "remote", remote)
        if use is not None:
            pulumi.set(__self__, "use", use)

    @_builtins.property
    @pulumi.getter
    def append(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Append a node to builder instead of changing it
        """
        return pulumi.get(self, "append")

    @append.setter
    def append(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "append", value)

    @_builtins.property
    @pulumi.getter
    def bootstrap(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Automatically boot the builder after creation. Defaults to `false`
        """
        return pulumi.get(self, "bootstrap")

    @bootstrap.setter
    def bootstrap(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bootstrap", value)

    @_builtins.property
    @pulumi.getter(name="buildkitConfig")
    def buildkit_config(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BuildKit daemon config file
        """
        return pulumi.get(self, "buildkit_config")

    @buildkit_config.setter
    def buildkit_config(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buildkit_config", value)

    @_builtins.property
    @pulumi.getter(name="buildkitFlags")
    def buildkit_flags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        BuildKit flags to set for the builder.
        """
        return pulumi.get(self, "buildkit_flags")

    @buildkit_flags.setter
    def buildkit_flags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "buildkit_flags", value)

    @_builtins.property
    @pulumi.getter(name="dockerContainer")
    def docker_container(self) -> Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']]:
        """
        Configuration block for the Docker-Container driver.
        """
        return pulumi.get(self, "docker_container")

    @docker_container.setter
    def docker_container(self, value: Optional[pulumi.Input['BuildxBuilderDockerContainerArgs']]):
        pulumi.set(self, "docker_container", value)

    @_builtins.property
    @pulumi.getter
    def driver(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        """
        return pulumi.get(self, "driver")

    @driver.setter
    def driver(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver", value)

    @_builtins.property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        """
        return pulumi.get(self, "driver_options")

    @driver_options.setter
    def driver_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "driver_options", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def kubernetes(self) -> Optional[pulumi.Input['BuildxBuilderKubernetesArgs']]:
        """
        Configuration block for the Kubernetes driver.
        """
        return pulumi.get(self, "kubernetes")

    @kubernetes.setter
    def kubernetes(self, value: Optional[pulumi.Input['BuildxBuilderKubernetesArgs']]):
        pulumi.set(self, "kubernetes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Buildx builder. IF not specified, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create/modify node with given name
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node", value)

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Fixed platforms for current node
        """
        return pulumi.get(self, "platforms")

    @platforms.setter
    def platforms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "platforms", value)

    @_builtins.property
    @pulumi.getter
    def remote(self) -> Optional[pulumi.Input['BuildxBuilderRemoteArgs']]:
        """
        Configuration block for the Remote driver.
        """
        return pulumi.get(self, "remote")

    @remote.setter
    def remote(self, value: Optional[pulumi.Input['BuildxBuilderRemoteArgs']]):
        pulumi.set(self, "remote", value)

    @_builtins.property
    @pulumi.getter
    def use(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Set the current builder instance as the default for the current context.
        """
        return pulumi.get(self, "use")

    @use.setter
    def use(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use", value)


@pulumi.type_token("docker:index/buildxBuilder:BuildxBuilder")
class BuildxBuilder(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 buildkit_config: Optional[pulumi.Input[_builtins.str]] = None,
                 buildkit_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_container: Optional[pulumi.Input[Union['BuildxBuilderDockerContainerArgs', 'BuildxBuilderDockerContainerArgsDict']]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input[Union['BuildxBuilderKubernetesArgs', 'BuildxBuilderKubernetesArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 remote: Optional[pulumi.Input[Union['BuildxBuilderRemoteArgs', 'BuildxBuilderRemoteArgsDict']]] = None,
                 use: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Docker Buildx builder instance. This resource allows you to create a  buildx builder with various configurations such as driver, nodes, and platform settings. Please see https://github.com/docker/buildx/blob/master/docs/reference/buildx_create.md for more documentation

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] append: Append a node to builder instead of changing it
        :param pulumi.Input[_builtins.bool] bootstrap: Automatically boot the builder after creation. Defaults to `false`
        :param pulumi.Input[_builtins.str] buildkit_config: BuildKit daemon config file
        :param pulumi.Input[_builtins.str] buildkit_flags: BuildKit flags to set for the builder.
        :param pulumi.Input[Union['BuildxBuilderDockerContainerArgs', 'BuildxBuilderDockerContainerArgsDict']] docker_container: Configuration block for the Docker-Container driver.
        :param pulumi.Input[_builtins.str] driver: The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] driver_options: Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        :param pulumi.Input[Union['BuildxBuilderKubernetesArgs', 'BuildxBuilderKubernetesArgsDict']] kubernetes: Configuration block for the Kubernetes driver.
        :param pulumi.Input[_builtins.str] name: The name of the Buildx builder. IF not specified, a random name will be generated.
        :param pulumi.Input[_builtins.str] node: Create/modify node with given name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: Fixed platforms for current node
        :param pulumi.Input[Union['BuildxBuilderRemoteArgs', 'BuildxBuilderRemoteArgsDict']] remote: Configuration block for the Remote driver.
        :param pulumi.Input[_builtins.bool] use: Set the current builder instance as the default for the current context.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BuildxBuilderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Docker Buildx builder instance. This resource allows you to create a  buildx builder with various configurations such as driver, nodes, and platform settings. Please see https://github.com/docker/buildx/blob/master/docs/reference/buildx_create.md for more documentation

        :param str resource_name: The name of the resource.
        :param BuildxBuilderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BuildxBuilderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 append: Optional[pulumi.Input[_builtins.bool]] = None,
                 bootstrap: Optional[pulumi.Input[_builtins.bool]] = None,
                 buildkit_config: Optional[pulumi.Input[_builtins.str]] = None,
                 buildkit_flags: Optional[pulumi.Input[_builtins.str]] = None,
                 docker_container: Optional[pulumi.Input[Union['BuildxBuilderDockerContainerArgs', 'BuildxBuilderDockerContainerArgsDict']]] = None,
                 driver: Optional[pulumi.Input[_builtins.str]] = None,
                 driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes: Optional[pulumi.Input[Union['BuildxBuilderKubernetesArgs', 'BuildxBuilderKubernetesArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node: Optional[pulumi.Input[_builtins.str]] = None,
                 platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 remote: Optional[pulumi.Input[Union['BuildxBuilderRemoteArgs', 'BuildxBuilderRemoteArgsDict']]] = None,
                 use: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BuildxBuilderArgs.__new__(BuildxBuilderArgs)

            __props__.__dict__["append"] = append
            __props__.__dict__["bootstrap"] = bootstrap
            __props__.__dict__["buildkit_config"] = buildkit_config
            __props__.__dict__["buildkit_flags"] = buildkit_flags
            __props__.__dict__["docker_container"] = docker_container
            __props__.__dict__["driver"] = driver
            __props__.__dict__["driver_options"] = driver_options
            __props__.__dict__["endpoint"] = endpoint
            __props__.__dict__["kubernetes"] = kubernetes
            __props__.__dict__["name"] = name
            __props__.__dict__["node"] = node
            __props__.__dict__["platforms"] = platforms
            __props__.__dict__["remote"] = remote
            __props__.__dict__["use"] = use
        super(BuildxBuilder, __self__).__init__(
            'docker:index/buildxBuilder:BuildxBuilder',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            append: Optional[pulumi.Input[_builtins.bool]] = None,
            bootstrap: Optional[pulumi.Input[_builtins.bool]] = None,
            buildkit_config: Optional[pulumi.Input[_builtins.str]] = None,
            buildkit_flags: Optional[pulumi.Input[_builtins.str]] = None,
            docker_container: Optional[pulumi.Input[Union['BuildxBuilderDockerContainerArgs', 'BuildxBuilderDockerContainerArgsDict']]] = None,
            driver: Optional[pulumi.Input[_builtins.str]] = None,
            driver_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes: Optional[pulumi.Input[Union['BuildxBuilderKubernetesArgs', 'BuildxBuilderKubernetesArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node: Optional[pulumi.Input[_builtins.str]] = None,
            platforms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            remote: Optional[pulumi.Input[Union['BuildxBuilderRemoteArgs', 'BuildxBuilderRemoteArgsDict']]] = None,
            use: Optional[pulumi.Input[_builtins.bool]] = None) -> 'BuildxBuilder':
        """
        Get an existing BuildxBuilder resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] append: Append a node to builder instead of changing it
        :param pulumi.Input[_builtins.bool] bootstrap: Automatically boot the builder after creation. Defaults to `false`
        :param pulumi.Input[_builtins.str] buildkit_config: BuildKit daemon config file
        :param pulumi.Input[_builtins.str] buildkit_flags: BuildKit flags to set for the builder.
        :param pulumi.Input[Union['BuildxBuilderDockerContainerArgs', 'BuildxBuilderDockerContainerArgsDict']] docker_container: Configuration block for the Docker-Container driver.
        :param pulumi.Input[_builtins.str] driver: The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] driver_options: Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        :param pulumi.Input[Union['BuildxBuilderKubernetesArgs', 'BuildxBuilderKubernetesArgsDict']] kubernetes: Configuration block for the Kubernetes driver.
        :param pulumi.Input[_builtins.str] name: The name of the Buildx builder. IF not specified, a random name will be generated.
        :param pulumi.Input[_builtins.str] node: Create/modify node with given name
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] platforms: Fixed platforms for current node
        :param pulumi.Input[Union['BuildxBuilderRemoteArgs', 'BuildxBuilderRemoteArgsDict']] remote: Configuration block for the Remote driver.
        :param pulumi.Input[_builtins.bool] use: Set the current builder instance as the default for the current context.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BuildxBuilderState.__new__(_BuildxBuilderState)

        __props__.__dict__["append"] = append
        __props__.__dict__["bootstrap"] = bootstrap
        __props__.__dict__["buildkit_config"] = buildkit_config
        __props__.__dict__["buildkit_flags"] = buildkit_flags
        __props__.__dict__["docker_container"] = docker_container
        __props__.__dict__["driver"] = driver
        __props__.__dict__["driver_options"] = driver_options
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["kubernetes"] = kubernetes
        __props__.__dict__["name"] = name
        __props__.__dict__["node"] = node
        __props__.__dict__["platforms"] = platforms
        __props__.__dict__["remote"] = remote
        __props__.__dict__["use"] = use
        return BuildxBuilder(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def append(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Append a node to builder instead of changing it
        """
        return pulumi.get(self, "append")

    @_builtins.property
    @pulumi.getter
    def bootstrap(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Automatically boot the builder after creation. Defaults to `false`
        """
        return pulumi.get(self, "bootstrap")

    @_builtins.property
    @pulumi.getter(name="buildkitConfig")
    def buildkit_config(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        BuildKit daemon config file
        """
        return pulumi.get(self, "buildkit_config")

    @_builtins.property
    @pulumi.getter(name="buildkitFlags")
    def buildkit_flags(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        BuildKit flags to set for the builder.
        """
        return pulumi.get(self, "buildkit_flags")

    @_builtins.property
    @pulumi.getter(name="dockerContainer")
    def docker_container(self) -> pulumi.Output[Optional['outputs.BuildxBuilderDockerContainer']]:
        """
        Configuration block for the Docker-Container driver.
        """
        return pulumi.get(self, "docker_container")

    @_builtins.property
    @pulumi.getter
    def driver(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The driver to use for the Buildx builder (e.g., docker-container, kubernetes).
        """
        return pulumi.get(self, "driver")

    @_builtins.property
    @pulumi.getter(name="driverOptions")
    def driver_options(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Additional options for the Buildx driver in the form of `key=value,...`. These options are driver-specific.
        """
        return pulumi.get(self, "driver_options")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The endpoint or context to use for the Buildx builder, where context is the name of a context from docker context ls and endpoint is the address for Docker socket (eg. DOCKER_HOST value). By default, the current Docker configuration is used for determining the context/endpoint value.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def kubernetes(self) -> pulumi.Output[Optional['outputs.BuildxBuilderKubernetes']]:
        """
        Configuration block for the Kubernetes driver.
        """
        return pulumi.get(self, "kubernetes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Buildx builder. IF not specified, a random name will be generated.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def node(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Create/modify node with given name
        """
        return pulumi.get(self, "node")

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Fixed platforms for current node
        """
        return pulumi.get(self, "platforms")

    @_builtins.property
    @pulumi.getter
    def remote(self) -> pulumi.Output[Optional['outputs.BuildxBuilderRemote']]:
        """
        Configuration block for the Remote driver.
        """
        return pulumi.get(self, "remote")

    @_builtins.property
    @pulumi.getter
    def use(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Set the current builder instance as the default for the current context.
        """
        return pulumi.get(self, "use")

