# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'RegistryAuth',
]

@pulumi.output_type
class RegistryAuth(dict):
    def __init__(__self__, *,
                 address: _builtins.str,
                 auth_disabled: Optional[_builtins.bool] = None,
                 config_file: Optional[_builtins.str] = None,
                 config_file_content: Optional[_builtins.str] = None,
                 password: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str address: Address of the registry
        :param _builtins.str config_file: Path to docker json file for registry auth. Defaults to `~/.docker/config.json`. If `DOCKER_CONFIG` is set, the value of `DOCKER_CONFIG` is used as the path. `config_file` has predencen over all other options.
        :param _builtins.str config_file_content: Plain content of the docker json file for registry auth. `config_file_content` has precedence over username/password.
        :param _builtins.str password: Password for the registry. Defaults to `DOCKER_REGISTRY_PASS` env variable if set.
        :param _builtins.str username: Username for the registry. Defaults to `DOCKER_REGISTRY_USER` env variable if set.
        """
        pulumi.set(__self__, "address", address)
        if auth_disabled is not None:
            pulumi.set(__self__, "auth_disabled", auth_disabled)
        if config_file is not None:
            pulumi.set(__self__, "config_file", config_file)
        if config_file_content is not None:
            pulumi.set(__self__, "config_file_content", config_file_content)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def address(self) -> _builtins.str:
        """
        Address of the registry
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter(name="authDisabled")
    def auth_disabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "auth_disabled")

    @_builtins.property
    @pulumi.getter(name="configFile")
    def config_file(self) -> Optional[_builtins.str]:
        """
        Path to docker json file for registry auth. Defaults to `~/.docker/config.json`. If `DOCKER_CONFIG` is set, the value of `DOCKER_CONFIG` is used as the path. `config_file` has predencen over all other options.
        """
        return pulumi.get(self, "config_file")

    @_builtins.property
    @pulumi.getter(name="configFileContent")
    def config_file_content(self) -> Optional[_builtins.str]:
        """
        Plain content of the docker json file for registry auth. `config_file_content` has precedence over username/password.
        """
        return pulumi.get(self, "config_file_content")

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        Password for the registry. Defaults to `DOCKER_REGISTRY_PASS` env variable if set.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        Username for the registry. Defaults to `DOCKER_REGISTRY_USER` env variable if set.
        """
        return pulumi.get(self, "username")


