# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetRegistryImageResult',
    'AwaitableGetRegistryImageResult',
    'get_registry_image',
    'get_registry_image_output',
]

@pulumi.output_type
class GetRegistryImageResult:
    """
    A collection of values returned by getRegistryImage.
    """
    def __init__(__self__, id=None, insecure_skip_verify=None, name=None, sha256_digest=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if insecure_skip_verify and not isinstance(insecure_skip_verify, bool):
            raise TypeError("Expected argument 'insecure_skip_verify' to be a bool")
        pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if sha256_digest and not isinstance(sha256_digest, str):
            raise TypeError("Expected argument 'sha256_digest' to be a str")
        pulumi.set(__self__, "sha256_digest", sha256_digest)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[_builtins.bool]:
        """
        If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
        """
        return pulumi.get(self, "insecure_skip_verify")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Docker image, including any tags. e.g. `alpine:latest`. You can also specify a digest, e.g. `nginx:1.28.0@sha256:eaa7e36decc3421fc04478c586dfea0d931cebe47d5bc0b15d758a32ba51126f`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sha256Digest")
    def sha256_digest(self) -> _builtins.str:
        """
        The content digest of the image, as stored in the registry.
        """
        return pulumi.get(self, "sha256_digest")


class AwaitableGetRegistryImageResult(GetRegistryImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegistryImageResult(
            id=self.id,
            insecure_skip_verify=self.insecure_skip_verify,
            name=self.name,
            sha256_digest=self.sha256_digest)


def get_registry_image(insecure_skip_verify: Optional[_builtins.bool] = None,
                       name: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegistryImageResult:
    """
    Reads the image metadata from a Docker Registry. Used in conjunction with the RemoteImage resource to keep an image up to date on the latest available version of the tag.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    ubuntu = docker.get_registry_image(name="ubuntu:precise")
    ubuntu_remote_image = docker.RemoteImage("ubuntu",
        name=ubuntu.name,
        pull_triggers=[ubuntu.sha256_digest])
    ```


    :param _builtins.bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param _builtins.str name: The name of the Docker image, including any tags. e.g. `alpine:latest`. You can also specify a digest, e.g. `nginx:1.28.0@sha256:eaa7e36decc3421fc04478c586dfea0d931cebe47d5bc0b15d758a32ba51126f`.
    """
    __args__ = dict()
    __args__['insecureSkipVerify'] = insecure_skip_verify
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('docker:index/getRegistryImage:getRegistryImage', __args__, opts=opts, typ=GetRegistryImageResult).value

    return AwaitableGetRegistryImageResult(
        id=pulumi.get(__ret__, 'id'),
        insecure_skip_verify=pulumi.get(__ret__, 'insecure_skip_verify'),
        name=pulumi.get(__ret__, 'name'),
        sha256_digest=pulumi.get(__ret__, 'sha256_digest'))
def get_registry_image_output(insecure_skip_verify: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                              name: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRegistryImageResult]:
    """
    Reads the image metadata from a Docker Registry. Used in conjunction with the RemoteImage resource to keep an image up to date on the latest available version of the tag.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_docker as docker

    ubuntu = docker.get_registry_image(name="ubuntu:precise")
    ubuntu_remote_image = docker.RemoteImage("ubuntu",
        name=ubuntu.name,
        pull_triggers=[ubuntu.sha256_digest])
    ```


    :param _builtins.bool insecure_skip_verify: If `true`, the verification of TLS certificates of the server/registry is disabled. Defaults to `false`
    :param _builtins.str name: The name of the Docker image, including any tags. e.g. `alpine:latest`. You can also specify a digest, e.g. `nginx:1.28.0@sha256:eaa7e36decc3421fc04478c586dfea0d931cebe47d5bc0b15d758a32ba51126f`.
    """
    __args__ = dict()
    __args__['insecureSkipVerify'] = insecure_skip_verify
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('docker:index/getRegistryImage:getRegistryImage', __args__, opts=opts, typ=GetRegistryImageResult)
    return __ret__.apply(lambda __response__: GetRegistryImageResult(
        id=pulumi.get(__response__, 'id'),
        insecure_skip_verify=pulumi.get(__response__, 'insecure_skip_verify'),
        name=pulumi.get(__response__, 'name'),
        sha256_digest=pulumi.get(__response__, 'sha256_digest')))
