# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TagArgs', 'Tag']

@pulumi.input_type
class TagArgs:
    def __init__(__self__, *,
                 source_image: pulumi.Input[_builtins.str],
                 target_image: pulumi.Input[_builtins.str],
                 tag_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Tag resource.
        :param pulumi.Input[_builtins.str] source_image: Name of the source image.
        :param pulumi.Input[_builtins.str] target_image: Name of the target image.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_triggers: List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        """
        pulumi.set(__self__, "source_image", source_image)
        pulumi.set(__self__, "target_image", target_image)
        if tag_triggers is not None:
            pulumi.set(__self__, "tag_triggers", tag_triggers)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the source image.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter(name="targetImage")
    def target_image(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the target image.
        """
        return pulumi.get(self, "target_image")

    @target_image.setter
    def target_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_image", value)

    @_builtins.property
    @pulumi.getter(name="tagTriggers")
    def tag_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        """
        return pulumi.get(self, "tag_triggers")

    @tag_triggers.setter
    def tag_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_triggers", value)


@pulumi.input_type
class _TagState:
    def __init__(__self__, *,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_image: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Tag resources.
        :param pulumi.Input[_builtins.str] source_image: Name of the source image.
        :param pulumi.Input[_builtins.str] source_image_id: ImageID of the source image in the format of `sha256:<<ID>>`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_triggers: List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        :param pulumi.Input[_builtins.str] target_image: Name of the target image.
        """
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_image_id is not None:
            pulumi.set(__self__, "source_image_id", source_image_id)
        if tag_triggers is not None:
            pulumi.set(__self__, "tag_triggers", tag_triggers)
        if target_image is not None:
            pulumi.set(__self__, "target_image", target_image)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the source image.
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image", value)

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ImageID of the source image in the format of `sha256:<<ID>>`
        """
        return pulumi.get(self, "source_image_id")

    @source_image_id.setter
    def source_image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_image_id", value)

    @_builtins.property
    @pulumi.getter(name="tagTriggers")
    def tag_triggers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        """
        return pulumi.get(self, "tag_triggers")

    @tag_triggers.setter
    def tag_triggers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tag_triggers", value)

    @_builtins.property
    @pulumi.getter(name="targetImage")
    def target_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the target image.
        """
        return pulumi.get(self, "target_image")

    @target_image.setter
    def target_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_image", value)


@pulumi.type_token("docker:index/tag:Tag")
class Tag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_image: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Creates a docker tag. It has the exact same functionality as the `docker tag` command. Deleting the resource will neither delete the source nor target images. The source image must exist on the machine running the docker daemon.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] source_image: Name of the source image.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_triggers: List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        :param pulumi.Input[_builtins.str] target_image: Name of the target image.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a docker tag. It has the exact same functionality as the `docker tag` command. Deleting the resource will neither delete the source nor target images. The source image must exist on the machine running the docker daemon.

        :param str resource_name: The name of the resource.
        :param TagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 source_image: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 target_image: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TagArgs.__new__(TagArgs)

            if source_image is None and not opts.urn:
                raise TypeError("Missing required property 'source_image'")
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["tag_triggers"] = tag_triggers
            if target_image is None and not opts.urn:
                raise TypeError("Missing required property 'target_image'")
            __props__.__dict__["target_image"] = target_image
            __props__.__dict__["source_image_id"] = None
        super(Tag, __self__).__init__(
            'docker:index/tag:Tag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            source_image: Optional[pulumi.Input[_builtins.str]] = None,
            source_image_id: Optional[pulumi.Input[_builtins.str]] = None,
            tag_triggers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            target_image: Optional[pulumi.Input[_builtins.str]] = None) -> 'Tag':
        """
        Get an existing Tag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] source_image: Name of the source image.
        :param pulumi.Input[_builtins.str] source_image_id: ImageID of the source image in the format of `sha256:<<ID>>`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tag_triggers: List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        :param pulumi.Input[_builtins.str] target_image: Name of the target image.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TagState.__new__(_TagState)

        __props__.__dict__["source_image"] = source_image
        __props__.__dict__["source_image_id"] = source_image_id
        __props__.__dict__["tag_triggers"] = tag_triggers
        __props__.__dict__["target_image"] = target_image
        return Tag(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the source image.
        """
        return pulumi.get(self, "source_image")

    @_builtins.property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> pulumi.Output[_builtins.str]:
        """
        ImageID of the source image in the format of `sha256:<<ID>>`
        """
        return pulumi.get(self, "source_image_id")

    @_builtins.property
    @pulumi.getter(name="tagTriggers")
    def tag_triggers(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of values which cause the tag to be (re)created. This is useful for triggering a new tag when the source image changes.
        """
        return pulumi.get(self, "tag_triggers")

    @_builtins.property
    @pulumi.getter(name="targetImage")
    def target_image(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the target image.
        """
        return pulumi.get(self, "target_image")

