import * as lambda from 'aws-cdk-lib/aws-lambda';
import { Construct } from 'constructs';
import { Agent } from './agent';
import { ApiSchema } from './api-schema';
export interface AgentActionGroupProps {
    /**
     * Bedrock Agent
     */
    readonly agent: Agent;
    /**
     * The Lambda function containing the business logic that is carried out upon invoking the action.
     */
    readonly actionGroupExecutor?: lambda.IFunction;
    /**
     * The name of the action group.
     *
     * @default - a name is generated by CloudFormation.
     */
    readonly actionGroupName?: string;
    /**
     * Specifies whether the action group is available for the agent to invoke or not when sending an InvokeAgent request.
     */
    readonly actionGroupState?: 'ENABLED' | 'DISABLED';
    /**
     * Contains details about the S3 object containing the OpenAPI schema for the action group. For more information, see
     * [Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).
     */
    readonly apiSchema?: ApiSchema;
    /**
     * A description of the action group.
     *
     * @note This object is a Union. Only one member of this object can be specified or returned.
     */
    readonly description?: string;
    /**
     * If you specify this value as AMAZON.UserInput, the agent will prompt additional information from the user when it
     * doesn't have enough information to respond to an utterance. Leave this field blank if you don't want the agent to
     * prompt additional information.
     */
    readonly parentActionGroupSignature?: 'AMAZON.UserInput';
    /**
     * Whether to prepare the agent for use.
     *
     * @default - false
     */
    readonly shouldPrepareAgent?: boolean;
}
export declare class AgentActionGroup extends Construct {
    /**
     * The unique identifier of the action group.
     */
    readonly actionGroupId: string;
    constructor(scope: Construct, id: string, props: AgentActionGroupProps);
}
