/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface AgentAliasProps {
    /**
     * The unique identifier of the agent.
     */
    readonly agentId: string;
    /**
     * The name for the agent alias.
     *
     * @default - 'latest'
     */
    readonly aliasName?: string;
    /**
     * The list of resource update timestamps to let CloudFormation determine when to update the alias.
     */
    readonly resourceUpdates?: string[];
    /**
     * The version of the agent to associate with the agent alias.
     *
     * @default - Creates a new version of the agent.
     */
    readonly agentVersion?: string;
}
export declare class AgentAlias extends Construct implements cdk.ITaggableV2 {
    /**
     * The unique identifier of the agent alias.
     */
    readonly aliasId: string;
    /**
     * The ARN of the agent alias.
     */
    readonly aliasArn: string;
    /**
     * The name for the agent alias.
     */
    readonly aliasName: string;
    /**
     * TagManager facilitates a common implementation of tagging for Constructs
     */
    readonly cdkTagManager: cdk.TagManager;
    constructor(scope: Construct, id: string, props: AgentAliasProps);
}
