"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentAlias = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const cdk_nag_1 = require("cdk-nag");
const constructs_1 = require("constructs");
const custom_resource_provider_1 = require("./custom-resource-provider");
class AgentAlias extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * TagManager facilitates a common implementation of tagging for Constructs
         */
        this.cdkTagManager = new cdk.TagManager(cdk.TagType.MAP, 'Custom::Bedrock-AgentAlias');
        const crProvider = custom_resource_provider_1.BedrockCRProvider.getProvider(this);
        const alias = new cdk.CustomResource(this, 'Alias', {
            serviceToken: crProvider.serviceToken,
            resourceType: 'Custom::Bedrock-AgentAlias',
            properties: {
                agentId: props.agentId,
                aliasName: props.aliasName ?? 'latest',
                resourceUpdates: props.resourceUpdates,
                agentVersion: props.agentVersion,
                tags: this.cdkTagManager.renderedTags,
            },
        });
        const aliasCRPolicy = new iam.Policy(this, 'AliasCRPolicy', {
            roles: [crProvider.role],
            statements: [
                new iam.PolicyStatement({
                    actions: [
                        'bedrock:CreateAgentAlias',
                        'bedrock:UpdateAgentAlias',
                        'bedrock:DeleteAgentAlias',
                        'bedrock:PrepareAgent',
                        'bedrock:ListAgentAliases',
                        'bedrock:ListAgentVersions',
                        'bedrock:DeleteAgentVersion',
                        'bedrock:GetAgent',
                        'bedrock:TagResource',
                    ],
                    resources: [
                        cdk.Stack.of(this).formatArn({
                            service: 'bedrock',
                            resource: 'agent-alias',
                            resourceName: '*',
                            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
                        }),
                        cdk.Stack.of(this).formatArn({
                            service: 'bedrock',
                            resource: 'agent',
                            resourceName: '*',
                            arnFormat: cdk.ArnFormat.SLASH_RESOURCE_NAME,
                        }),
                    ],
                }),
            ],
        });
        cdk_nag_1.NagSuppressions.addResourceSuppressions(aliasCRPolicy, [
            {
                id: 'AwsSolutions-IAM5',
                reason: 'Bedrock Agent/Alias associations have wildcards restricted to agents and aliases in the account.',
            },
        ], true);
        alias.node.addDependency(aliasCRPolicy);
        alias.node.addDependency(crProvider);
        this.aliasId = alias.getAttString('agentAliasId');
        this.aliasArn = alias.getAttString('agentAliasArn');
        this.aliasName = alias.getAttString('agentAliasName');
    }
}
exports.AgentAlias = AgentAlias;
_a = JSII_RTTI_SYMBOL_1;
AgentAlias[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.AgentAlias", version: "0.1.94" };
//# sourceMappingURL=data:application/json;base64,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