"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BedrockCRProvider = void 0;
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const path = require("path");
const lambda = require("aws-cdk-lib/aws-lambda");
const custom_resource_provider_helper_1 = require("../../common/helpers/custom-resource-provider-helper");
/**
 * The custom resource provider for Bedrock.
 *
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
exports.BedrockCRProvider = (0, custom_resource_provider_helper_1.buildCustomResourceProvider)({
    providerName: 'BedrockCRProvider',
    codePath: path.join(__dirname, '../../../lambda/bedrock-custom-resources'),
    handler: 'custom_resources.on_event',
    runtime: lambda.Runtime.PYTHON_3_12,
});
//# sourceMappingURL=data:application/json;base64,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