/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import { IConstruct } from 'constructs';
export interface BedrockFoundationModelProps {
    /**
     * Bedrock Agents can use this model.
     *
     * @default - false
     */
    readonly supportsAgents?: boolean;
    /**
     * Bedrock Knowledge Base can use this model.
     *
     * @default - false
     */
    readonly supportsKnowledgeBase?: boolean;
}
/**
 * Bedrock models.
 *
 * If you need to use a model name that doesn't exist as a static member, you
 * can instantiate a `BedrockFoundationModel` object, e.g: `new BedrockFoundationModel('my-model')`.
 */
export declare class BedrockFoundationModel {
    static readonly ANTHROPIC_CLAUDE_V2: BedrockFoundationModel;
    static readonly ANTHROPIC_CLAUDE_V2_1: BedrockFoundationModel;
    static readonly ANTHROPIC_CLAUDE_INSTANT_V1_2: BedrockFoundationModel;
    static readonly AMAZON_TITAN_TEXT_EXPRESS_V1: BedrockFoundationModel;
    static readonly TITAN_EMBED_TEXT_V1: BedrockFoundationModel;
    static readonly COHERE_EMBED_ENGLISH_V3: BedrockFoundationModel;
    static readonly COHERE_EMBED_MULTILINGUAL_V3: BedrockFoundationModel;
    readonly modelId: string;
    readonly supportsAgents: boolean;
    readonly supportsKnowledgeBase: boolean;
    constructor(value: string, props?: BedrockFoundationModelProps);
    toString(): string;
    asArn(construct: IConstruct): string;
}
