"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BedrockFoundationModel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const cdk = require("aws-cdk-lib");
/**
 * Bedrock models.
 *
 * If you need to use a model name that doesn't exist as a static member, you
 * can instantiate a `BedrockFoundationModel` object, e.g: `new BedrockFoundationModel('my-model')`.
 */
class BedrockFoundationModel {
    constructor(value, props = {}) {
        this.modelId = value;
        this.supportsAgents = props.supportsAgents ?? false;
        this.supportsKnowledgeBase = props.supportsKnowledgeBase ?? false;
    }
    toString() {
        return this.modelId;
    }
    asArn(construct) {
        const region = cdk.Stack.of(construct).region;
        return `arn:aws:bedrock:${region}::foundation-model/${this.modelId}`;
    }
}
exports.BedrockFoundationModel = BedrockFoundationModel;
_a = JSII_RTTI_SYMBOL_1;
BedrockFoundationModel[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.BedrockFoundationModel", version: "0.1.94" };
BedrockFoundationModel.ANTHROPIC_CLAUDE_V2 = new BedrockFoundationModel('anthropic.claude-v2', { supportsAgents: true });
BedrockFoundationModel.ANTHROPIC_CLAUDE_V2_1 = new BedrockFoundationModel('anthropic.claude-v2:1', { supportsAgents: true });
BedrockFoundationModel.ANTHROPIC_CLAUDE_INSTANT_V1_2 = new BedrockFoundationModel('anthropic.claude-instant-v1', { supportsAgents: true });
BedrockFoundationModel.AMAZON_TITAN_TEXT_EXPRESS_V1 = new BedrockFoundationModel('amazon.titan-text-express-v1', { supportsAgents: true });
BedrockFoundationModel.TITAN_EMBED_TEXT_V1 = new BedrockFoundationModel('amazon.titan-embed-text-v1', { supportsKnowledgeBase: true });
BedrockFoundationModel.COHERE_EMBED_ENGLISH_V3 = new BedrockFoundationModel('cohere.embed-english-v3', { supportsKnowledgeBase: true });
BedrockFoundationModel.COHERE_EMBED_MULTILINGUAL_V3 = new BedrockFoundationModel('cohere.embed-multilingual-v3', { supportsKnowledgeBase: true });
//# sourceMappingURL=data:application/json;base64,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