import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { VectorCollection } from '../opensearchserverless';
/**
 * Metadata field definitions.
 */
export interface MetadataManagementFieldProps {
    /**
     * The name of the field.
     */
    readonly mappingField: string;
    /**
     * The data type of the field.
     */
    readonly dataType: string;
    /**
     * Whether the field is filterable.
     */
    readonly filterable: boolean;
}
/**
 * Properties for the VectorIndex.
 */
export interface VectorIndexProps {
    /**
     * The OpenSearch Vector Collection.
     */
    readonly collection: VectorCollection;
    /**
     * The name of the index.
     */
    readonly indexName: string;
    /**
     * The name of the vector field.
     */
    readonly vectorField: string;
    /**
     * The number of dimensions in the vector.
     */
    readonly vectorDimensions: number;
    /**
     * The metadata management fields.
     */
    readonly mappings: MetadataManagementFieldProps[];
}
/**
 * Deploy a vector index on the collection.
 */
export declare class VectorIndex extends cdk.Resource {
    constructor(scope: Construct, id: string, props: VectorIndexProps);
}
/**
 * Custom Resource provider for OpenSearch Index operations.
 *
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
export declare const OpenSearchIndexCRProvider: import("../../common/helpers/custom-resource-provider-helper").ICRProviderClass;
