"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchIndexCRProvider = exports.VectorIndex = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const path = require("path");
const cdk = require("aws-cdk-lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const oss = require("aws-cdk-lib/aws-opensearchserverless");
const custom_resource_provider_helper_1 = require("../../common/helpers/custom-resource-provider-helper");
const utils_1 = require("../../common/helpers/utils");
/**
 * Deploy a vector index on the collection.
 */
class VectorIndex extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        const crProvider = exports.OpenSearchIndexCRProvider.getProvider(this);
        crProvider.role.addManagedPolicy(props.collection.aossPolicy);
        const manageIndexPolicyName = (0, utils_1.generatePhysicalNameV2)(this, 'ManageIndexPolicy', { maxLength: 32, lower: true });
        const manageIndexPolicy = new oss.CfnAccessPolicy(this, 'ManageIndexPolicy', {
            name: manageIndexPolicyName,
            type: 'data',
            policy: JSON.stringify([
                {
                    Rules: [
                        {
                            Resource: [`index/${props.collection.collectionName}/*`],
                            Permission: [
                                'aoss:DescribeIndex',
                                'aoss:CreateIndex',
                                'aoss:DeleteIndex',
                                'aoss:UpdateIndex',
                            ],
                            ResourceType: 'index',
                        },
                        {
                            Resource: [`collection/${props.collection.collectionName}`],
                            Permission: [
                                'aoss:DescribeCollectionItems',
                            ],
                            ResourceType: 'collection',
                        },
                    ],
                    Principal: [
                        crProvider.role.roleArn,
                    ],
                    Description: '',
                },
            ]),
        });
        const vectorIndex = new cdk.CustomResource(this, 'VectorIndex', {
            serviceToken: crProvider.serviceToken,
            properties: {
                Endpoint: `${props.collection.collectionId}.${cdk.Stack.of(this).region}.aoss.amazonaws.com`,
                IndexName: props.indexName,
                VectorField: props.vectorField,
                Dimensions: props.vectorDimensions,
                MetadataManagement: props.mappings.map((m) => {
                    return {
                        MappingField: m.mappingField,
                        DataType: m.dataType,
                        Filterable: m.filterable,
                    };
                }),
            },
            resourceType: 'Custom::OpenSearchIndex',
        });
        vectorIndex.node.addDependency(manageIndexPolicy);
        vectorIndex.node.addDependency(props.collection);
        vectorIndex.node.addDependency(props.collection.dataAccessPolicy);
    }
}
exports.VectorIndex = VectorIndex;
_a = JSII_RTTI_SYMBOL_1;
VectorIndex[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.opensearch_vectorindex.VectorIndex", version: "0.1.94" };
/**
 * Custom Resource provider for OpenSearch Index operations.
 *
 * @internal This is an internal core function and should not be called directly by Solutions Constructs clients.
 */
exports.OpenSearchIndexCRProvider = (0, custom_resource_provider_helper_1.buildCustomResourceProvider)({
    providerName: 'OpenSearchIndexCRProvider',
    codePath: path.join(__dirname, '../../../lambda/opensearch-serverless-custom-resources'),
    handler: 'custom_resources.on_event',
    runtime: lambda.Runtime.PYTHON_3_12,
});
//# sourceMappingURL=data:application/json;base64,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